/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.utils;

import egovframework.dev.imp.core.utils.BMatchAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;

public class BTextSearchRequestor
extends TextSearchRequestor {
    private final boolean fIsFileSearchOnly;
    private final String fFileName;
    private final ArrayList<HashMap<String, Object>> result;
    private HashMap<String, Object> detected;

    public BTextSearchRequestor(boolean isFileSearchOnly, String fileName) {
        this.fFileName = fileName;
        this.fIsFileSearchOnly = isFileSearchOnly;
        this.result = new ArrayList();
    }

    public String getfFileName() {
        return this.fFileName;
    }

    public boolean acceptFile(IFile file) throws CoreException {
        if (this.fIsFileSearchOnly) {
            if (this.detected == null || !file.equals(this.detected.get("file"))) {
                this.detected = new HashMap();
            }
            this.detected.put("file", file);
            this.result.add(this.detected);
        }
        return true;
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
        int start = matchRequestor.getMatchOffset();
        int length = matchRequestor.getMatchLength();
        String matchStr = matchRequestor.getFileContent(start, length);
        IFile file = matchRequestor.getFile();
        if (this.detected == null || !file.equals(this.detected.get("file"))) {
            this.detected = new HashMap();
            this.detected.put("file", file);
            this.result.add(this.detected);
        }
        List<BMatchAccessor> matched = null;
        if (this.detected.get("match_data") == null) {
            matched = new ArrayList();
            this.detected.put("match_data", matched);
        } else {
            matched = (List)this.detected.get("match_data");
        }
        matched.add(new BMatchAccessor(matchStr, start, length));
        return true;
    }

    public List<HashMap<String, Object>> getSearchResult() {
        return this.result;
    }
}

