/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.utils;

import egovframework.dev.imp.core.utils.BTextSearchRequestor;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;

public class BTextSearchUtil {
    public static final String K_FILE = "file";
    public static final String K_MATCH = "match_data";

    public static List<?> findFiles(IResource[] roots, String includedText, String qualifiedFileName, boolean isRegexSearch, IProgressMonitor monitor) {
        List<?> result = null;
        String[] fileNamePattern = new String[]{qualifiedFileName};
        String includedText2 = includedText;
        if (includedText == null) {
            includedText2 = "";
        }
        FileTextSearchScope scope = null;
        scope = roots == null ? FileTextSearchScope.newWorkspaceScope((String[])fileNamePattern, (boolean)true) : FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePattern, (boolean)true);
        Pattern pattern = BTextSearchUtil.createPattern(includedText2, false, isRegexSearch);
        boolean isFileSearchOnly = pattern.pattern().length() == 0;
        BTextSearchRequestor collector = new BTextSearchRequestor(isFileSearchOnly, qualifiedFileName);
        result = BTextSearchUtil.findFiles((TextSearchScope)scope, pattern, collector, monitor);
        return result;
    }

    public static List<?> findFiles(IResource[] roots, String includedText, String fileName, String extension, boolean isRegexSearch, IProgressMonitor monitor) {
        List<?> result = null;
        String[] fileNamePattern = null;
        String fileName2 = fileName;
        String extension2 = extension;
        String includedText2 = includedText;
        fileName2 = fileName2 == null || "".equals(fileName2) ? "*" : "*" + fileName2 + "*";
        if (extension2 == null || "".equals(extension2)) {
            extension2 = "*";
        }
        String[] extensions = extension2.split(",");
        fileNamePattern = new String[extensions.length];
        int idx = 0;
        while (idx < extensions.length) {
            fileNamePattern[idx] = String.valueOf(fileName2) + "." + extensions[idx];
            ++idx;
        }
        if (includedText2 == null) {
            includedText2 = "";
        }
        FileTextSearchScope scope = null;
        scope = roots == null ? FileTextSearchScope.newWorkspaceScope((String[])fileNamePattern, (boolean)true) : FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePattern, (boolean)true);
        Pattern pattern = BTextSearchUtil.createPattern(includedText2, false, isRegexSearch);
        boolean isFileSearchOnly = pattern.pattern().length() == 0;
        BTextSearchRequestor collector = new BTextSearchRequestor(isFileSearchOnly, fileName2);
        result = BTextSearchUtil.findFiles((TextSearchScope)scope, pattern, collector, monitor);
        return result;
    }

    public static List<?> findFiles(TextSearchScope scope, Pattern pattern, BTextSearchRequestor collector, IProgressMonitor monitor) {
        List<HashMap<String, Object>> result = null;
        IStatus status = TextSearchEngine.create().search(scope, (TextSearchRequestor)collector, pattern, null);
        if (status != null && status.getCode() == 0) {
            result = collector.getSearchResult();
        }
        return result;
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        String pattern2 = pattern;
        if (!isRegexSearch) {
            pattern2 = BTextSearchUtil.asRegEx(pattern2, new StringBuffer()).toString();
        }
        if (!isCaseSensitive) {
            return Pattern.compile(pattern2, 74);
        }
        return Pattern.compile(pattern2, 8);
    }

    private static StringBuffer asRegEx(String stringMatcherPattern, StringBuffer out) {
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < stringMatcherPattern.length()) {
            char ch;
            if ((ch = stringMatcherPattern.charAt(i++)) == '*' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".*");
                escaped = false;
                continue;
            }
            if (ch == '?' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".");
                escaped = false;
                continue;
            }
            if (ch == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (ch == '\\' && escaped) {
                escaped = false;
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
                continue;
            }
            if (!quoting) {
                out.append("\\Q");
                quoting = true;
            }
            if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                out.append('\\');
            }
            out.append(ch);
            boolean bl = escaped = ch == '\\';
        }
        if (quoting) {
            out.append("\\E");
        }
        return out;
    }
}

