/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.utils;

import egovframework.dev.imp.core.utils.BTextSearchRequestor;
import egovframework.dev.imp.core.utils.BTextSearchUtil;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;

public class EgovProperties {
    public static final String ERR_CODE = " EXCEPTION OCCURRED";
    public static final String ERR_CODE_FNFE = " EXCEPTION(FNFE) OCCURRED";
    public static final String ERR_CODE_IOE = " EXCEPTION(IOE) OCCURRED";
    public static List<?> foundFiles = null;
    public static File actualFile = null;
    static final char FILE_SEPARATOR = File.separatorChar;

    /*
     * Loose catch block
     */
    public static String getProperty(String keyName) {
        String value = ERR_CODE;
        value = "99";
        EgovProperties.debug(actualFile + " : " + keyName);
        FileInputStream fis = null;
        try {
            try {
                Properties props = new Properties();
                fis = new FileInputStream(actualFile);
                props.load(new BufferedInputStream(fis));
                value = props.getProperty(keyName).trim();
            }
            catch (FileNotFoundException fne) {
                EgovProperties.debug(fne);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (IOException ioe) {
                EgovProperties.debug(ioe);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                EgovProperties.debug(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return value;
    }

    public static String getProperty(String fileName, String key) {
        FileInputStream fis = null;
        try {
            String value;
            Properties props = new Properties();
            fis = new FileInputStream(fileName);
            props.load(new BufferedInputStream(fis));
            fis.close();
            String string = value = props.getProperty(key);
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return ERR_CODE_FNFE;
        }
        catch (IOException iOException) {
            return ERR_CODE_IOE;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static ArrayList<Map<String, String>> loadPropertyFile(String property) {
        ArrayList<Map<String, String>> keyList = new ArrayList<Map<String, String>>();
        String src = property.replace('\\', FILE_SEPARATOR).replace('/', FILE_SEPARATOR);
        FileInputStream fis = null;
        try {
            try {
                File srcFile = new File(src);
                if (srcFile.exists()) {
                    Properties props = new Properties();
                    fis = new FileInputStream(src);
                    props.load(new BufferedInputStream(fis));
                    fis.close();
                    Enumeration<?> plist = props.propertyNames();
                    if (plist != null) {
                        while (plist.hasMoreElements()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            String key = (String)plist.nextElement();
                            map.put(key, props.getProperty(key));
                            keyList.add(map);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return keyList;
    }

    public static File getPropertiesFile(IJavaProject project) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            List<IPackageFragmentRoot> realList = null;
            realList = EgovJavaElementUtil.getSourceFolders(project);
            actualFile = null;
            int i = 0;
            while (i < realList.size()) {
                foundFiles = EgovProperties.findFiles(realList.get(i).getResource().getParent().members(), "", "globals.properties", true, (IProgressMonitor)monitor);
                int j = 0;
                while (j < foundFiles.size()) {
                    Map map = (Map)foundFiles.get(j);
                    Object f = map.get("file");
                    if (f instanceof IFile) {
                        actualFile = ((IFile)f).getFullPath().toFile();
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            EgovProperties.debug((Object)e);
        }
        catch (CoreException e) {
            EgovProperties.debug((Object)e);
        }
        return actualFile;
    }

    public static List<?> findFiles(IResource[] roots, String includedText, String qualifiedFileName, boolean isRegexSearch, IProgressMonitor monitor) {
        List<?> result = null;
        String[] fileNamePattern = new String[]{qualifiedFileName};
        String includedText2 = includedText;
        if (includedText == null) {
            includedText2 = "";
        }
        FileTextSearchScope scope = null;
        scope = roots == null ? FileTextSearchScope.newWorkspaceScope((String[])fileNamePattern, (boolean)true) : FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePattern, (boolean)true);
        Pattern pattern = BTextSearchUtil.createPattern(includedText2, false, isRegexSearch);
        boolean isFileSearchOnly = pattern.pattern().length() == 0;
        BTextSearchRequestor collector = new BTextSearchRequestor(isFileSearchOnly, qualifiedFileName);
        result = BTextSearchUtil.findFiles((TextSearchScope)scope, pattern, collector, monitor);
        return result;
    }

    private static void debug(Object obj) {
        if (obj instanceof Exception) {
            ((Exception)obj).printStackTrace();
        }
    }
}

