/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.utils;

import egovframework.dev.imp.core.common.CoreLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PrefrencePropertyUtil {
    public static Object loadPreferences(AbstractUIPlugin plugin, Object vo) {
        IPreferenceStore store = plugin.getPreferenceStore();
        Class<?> c = vo.getClass();
        Field[] fields = c.getDeclaredFields();
        int idx = 0;
        while (idx < fields.length) {
            try {
                Class<?> cls;
                Method method;
                if ((Modifier.isPrivate(fields[idx].getModifiers()) || Modifier.isPublic(fields[idx].getModifiers())) && (method = PrefrencePropertyUtil.getMethod(c, new String[]{"set"}, fields[idx], new Class[]{cls = fields[idx].getType()})) != null && method.getName() != "setId") {
                    String fname = cls.getName();
                    String path = String.valueOf(PrefrencePropertyUtil.getId(vo)) + fields[idx].getName();
                    if ("java.lang.String".equals(fname)) {
                        String o = store.getString(path);
                        method.invoke(vo, o == null ? "" : o);
                    } else if ("boolean".equals(fname)) {
                        method.invoke(vo, store.getBoolean(path));
                    } else if ("double".equals(fname)) {
                        method.invoke(vo, new Double(store.getDouble(path)));
                    } else if ("float".equals(fname)) {
                        method.invoke(vo, new Float(store.getFloat(path)));
                    } else if ("int".equals(fname)) {
                        method.invoke(vo, store.getInt(path));
                    } else if ("long".equals(fname)) {
                        method.invoke(vo, store.getLong(path));
                    }
                }
            }
            catch (Exception e) {
                CoreLog.logError(e);
            }
            ++idx;
        }
        return vo;
    }

    public static void savePreferences(AbstractUIPlugin plugin, Object vo) {
        IPreferenceStore store = plugin.getPreferenceStore();
        Class<?> c = vo.getClass();
        Field[] fields = c.getDeclaredFields();
        int idx = 0;
        while (idx < fields.length) {
            try {
                Method method;
                if ((Modifier.isPrivate(fields[idx].getModifiers()) || Modifier.isPublic(fields[idx].getModifiers())) && (method = PrefrencePropertyUtil.getMethod(c, new String[]{"get", "is"}, fields[idx], new Class[0])) != null) {
                    String fname = fields[idx].getType().getName();
                    String path = String.valueOf(PrefrencePropertyUtil.getId(vo)) + fields[idx].getName();
                    if ("java.lang.String".equals(fname)) {
                        if ((String)method.invoke(vo, new Object[0]) != null) {
                            store.setValue(path, (String)method.invoke(vo, new Object[0]));
                        }
                    } else if ("boolean".equals(fname)) {
                        if ((Boolean)method.invoke(vo, new Object[0]) != null) {
                            store.setValue(path, ((Boolean)method.invoke(vo, new Object[0])).booleanValue());
                        }
                        store.getBoolean(path);
                    } else if ("double".equals(fname)) {
                        if ((Double)method.invoke(vo, new Object[0]) != null) {
                            store.setValue(path, ((Double)method.invoke(vo, new Object[0])).doubleValue());
                        }
                    } else if ("float".equals(fname)) {
                        if ((Float)method.invoke(vo, new Object[0]) != null) {
                            store.setValue(path, ((Float)method.invoke(vo, new Object[0])).floatValue());
                        }
                    } else if ("int".equals(fname)) {
                        if ((Integer)method.invoke(vo, new Object[0]) != null) {
                            store.setValue(path, ((Integer)method.invoke(vo, new Object[0])).intValue());
                        }
                    } else if ("long".equals(fname) && (Long)method.invoke(vo, new Object[0]) != null) {
                        store.setValue(path, ((Long)method.invoke(vo, new Object[0])).longValue());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++idx;
        }
        plugin.savePluginPreferences();
    }

    private static String getId(Object vo) {
        String id = "*.";
        try {
            id = String.valueOf((String)vo.getClass().getMethod("getId", new Class[0]).invoke(vo, new Object[0])) + ".";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    private static Method getMethod(Class clazz, String[] prefixes, Field field, Class[] classes) {
        Method method = null;
        String fname = String.valueOf(field.getName().substring(0, 1).toUpperCase()) + field.getName().substring(1);
        int idx = 0;
        while (idx < prefixes.length) {
            try {
                method = clazz.getMethod(String.valueOf(prefixes[idx]) + fname, classes);
                break;
            }
            catch (NoSuchMethodException e) {
                CoreLog.logError(e);
                ++idx;
            }
        }
        return method;
    }
}

