/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.utils;

import egovframework.dev.imp.core.utils.NullUtil;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Label;

public class StringUtil {
    public static String ENG_PATTERN = "a-zA-Z";
    public static String KOR_PATTERN = "\uac00-\ud7a3\u3131-\u314e\u314f-\u3163";
    public static String NUM_PATTERN = "0-9";

    public static String nvl(String value) {
        return value == null ? "" : value;
    }

    public static boolean doesStringMatchWithPatten(String pattern, String string) {
        return Pattern.matches("[" + pattern + "]+", string);
    }

    public static boolean doesCharacterBelongToPattern(String pattern, char character) {
        String string = Character.toString(character);
        return Pattern.matches("[" + pattern + "]+", string);
    }

    public static boolean hasEmptySpace(String string) {
        return StringUtil.doesStringHasSignal(' ', string);
    }

    public static boolean isSignalFirstOrLast(char signal, String string) {
        if (NullUtil.isEmpty(string)) {
            return false;
        }
        char[] characters = string.toCharArray();
        return characters[0] == signal || characters[characters.length - 1] == signal;
    }

    public static boolean isSignalsFirstOrLast(String signals, String string) {
        if (NullUtil.isEmpty(signals)) {
            return false;
        }
        char[] charSignals = signals.toCharArray();
        if (!NullUtil.isNull(charSignals)) {
            char[] cArray = charSignals;
            int n = charSignals.length;
            int n2 = 0;
            while (n2 < n) {
                char signal = cArray[n2];
                if (StringUtil.isSignalFirstOrLast(signal, string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean doesCharacterOfStringBelongToPatternAtleastOne(String pattern, String string) {
        char[] chars = string.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (StringUtil.doesCharacterBelongToPattern(pattern, chars[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean doesStringHasSignalsAtLeastOneCharacter(String signals, String string) {
        char[] charSignals;
        char[] cArray = charSignals = signals.toCharArray();
        int n = charSignals.length;
        int n2 = 0;
        while (n2 < n) {
            char signal = cArray[n2];
            if (StringUtil.doesStringHasSignal(signal, string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean doesStringHasSignal(char signal, String string) {
        return string.indexOf(signal) > -1;
    }

    public static String returnEmptyStringIfNull(String string) {
        if (NullUtil.isEmpty(string)) {
            return "";
        }
        return string;
    }

    public static boolean isStringStartWithNumber(String string) {
        if (!NullUtil.isEmpty(string)) {
            char firstChar = string.charAt(0);
            return Character.isDigit(firstChar);
        }
        return false;
    }

    public static boolean hasKorean(String string) {
        return StringUtil.doesCharacterOfStringBelongToPatternAtleastOne(KOR_PATTERN, string);
    }

    public static boolean isAlphabetAndNumber(String string) {
        return StringUtil.doesStringMatchWithPatten(String.valueOf(ENG_PATTERN) + NUM_PATTERN, string);
    }

    public static boolean hasInvalidClassFileSignal(String string) {
        String invalidChar = "<>/?:*|\"\\";
        return StringUtil.doesStringHasSignalsAtLeastOneCharacter(invalidChar, string);
    }

    public static boolean isBatchJobBeanIDAvailable(String beanID) {
        String signals = ".-";
        String pattern = String.valueOf(ENG_PATTERN) + NUM_PATTERN + signals;
        if (StringUtil.doesStringMatchWithPatten(pattern, beanID)) {
            return !StringUtil.isSignalsFirstOrLast(signals, beanID) && !StringUtil.isStringStartWithNumber(beanID);
        }
        return false;
    }

    public static void setLabelStringBold(Label label) {
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
    }
}

