/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static final int BLOCK_SIZE = 4096;
    protected static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected static DocumentBuilderFactory vfactory = DocumentBuilderFactory.newInstance();

    static {
        factory.setValidating(false);
        vfactory.setValidating(true);
    }

    public static Node getRootNode(String filePath) throws Exception {
        Document doc = XmlUtil.parsing(filePath, false);
        Element root = doc.getDocumentElement();
        return root;
    }

    public static Node getRootNode(InputStream contents) throws Exception {
        Document doc = XmlUtil.parsing(contents, false);
        Element root = doc.getDocumentElement();
        return root;
    }

    public static Node getRootNode(File file) throws Exception {
        Document doc = XmlUtil.parsing(file, false);
        Element root = doc.getDocumentElement();
        return root;
    }

    public static void addComment(Node contextNode, String xPath, String commentStr) throws Exception {
        Document doc = contextNode.getOwnerDocument();
        Comment com = doc.createComment(commentStr);
        contextNode.appendChild(com);
    }

    public static void addComment(Node contextNode, String xPath, String commentStr, String beforeText, String afterText) throws Exception {
        Document doc = contextNode.getOwnerDocument();
        Comment com = doc.createComment(commentStr);
        Text preValueText = doc.createTextNode(beforeText);
        Text postValueText = doc.createTextNode(afterText);
        contextNode.appendChild(preValueText);
        contextNode.appendChild(com);
        contextNode.appendChild(postValueText);
    }

    public static boolean existNode(Node contextNode, String xPath) throws Exception {
        Node searchNode = XmlUtil.getNode(contextNode, xPath);
        return searchNode != null;
    }

    public static boolean existNodeValue(Node contextNode, String xPath, String compareValue) throws Exception {
        Node searchNode = XmlUtil.getNode(contextNode, xPath);
        Node valueNode = searchNode.getFirstChild();
        if (valueNode == null) {
            return false;
        }
        String nodeValue = valueNode.getNodeValue();
        return compareValue.equals(nodeValue);
    }

    public static boolean modifyNodeValue(Node contextNode, String xPath, String value) throws Exception {
        Node searchNode = XmlUtil.getNode(contextNode, xPath);
        Node valueNode = searchNode.getFirstChild();
        if (valueNode == null || valueNode.getNodeType() != 3) {
            return false;
        }
        valueNode.setNodeValue(value);
        return true;
    }

    @Deprecated
    public static void saveXmlFile(String filePath, Node contextNode) throws Exception {
    }

    public static Node getNode(Node contextNode, String xPath) throws Exception {
        XObject xobject = XPathAPI.eval((Node)contextNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        if (componentList == null || componentList.getLength() == 0) {
            return null;
        }
        Node componentNode = componentList.item(0);
        return componentNode;
    }

    public static NodeList getNodeList(Node contextNode, String xPath) throws Exception {
        XObject xobject = XPathAPI.eval((Node)contextNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        if (componentList == null || componentList.getLength() == 0) {
            return null;
        }
        return componentList;
    }

    public static void addNode(Node contextNode, String xPath, String xmlStr) throws Exception {
        XObject xobject = XPathAPI.eval((Node)contextNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        if (componentList == null || componentList.getLength() == 0) {
            return;
        }
        Node parentsNode = componentList.item(0);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
        Element node = doc.getDocumentElement();
        Document ownerDoc = parentsNode.getOwnerDocument();
        Node importedNode = ownerDoc.importNode(node, true);
        parentsNode.appendChild(importedNode);
    }

    public static void addNode(Node contextNode, String xPath, String xmlStr, String beforeText, String afterText) throws Exception {
        XObject xobject = XPathAPI.eval((Node)contextNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        if (componentList == null || componentList.getLength() == 0) {
            return;
        }
        Node parentsNode = componentList.item(0);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
        Element node = doc.getDocumentElement();
        Document ownerDoc = parentsNode.getOwnerDocument();
        Node importedNode = ownerDoc.importNode(node, true);
        Text preValueText = ownerDoc.createTextNode(beforeText);
        Text postValueText = ownerDoc.createTextNode(afterText);
        parentsNode.appendChild(preValueText);
        parentsNode.appendChild(importedNode);
        parentsNode.appendChild(postValueText);
    }

    public static void addFirstNode(Node contextNode, String xPath, String xmlStr, String beforeText, String afterText) throws Exception {
        XObject xobject = XPathAPI.eval((Node)contextNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        if (componentList == null || componentList.getLength() == 0) {
            return;
        }
        Node parentsNode = componentList.item(0);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
        Element node = doc.getDocumentElement();
        Document ownerDoc = parentsNode.getOwnerDocument();
        Node importedNode = ownerDoc.importNode(node, true);
        Text preValueText = ownerDoc.createTextNode(beforeText);
        Text postValueText = ownerDoc.createTextNode(afterText);
        Node firstNode = parentsNode.getFirstChild();
        importedNode.getTextContent();
        parentsNode.insertBefore(preValueText, firstNode);
        parentsNode.insertBefore(importedNode, firstNode);
        parentsNode.insertBefore(postValueText, firstNode);
    }

    public static boolean removeNode(Node contextNode, String xPath) throws Exception {
        XObject xobject = XPathAPI.eval((Node)contextNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        if (componentList == null || componentList.getLength() == 0) {
            return false;
        }
        Node componentNode = componentList.item(0);
        componentNode.getTextContent();
        Node parentNode = componentNode.getParentNode();
        Node previousNode = componentNode.getPreviousSibling();
        parentNode.getTextContent();
        parentNode.removeChild(componentNode);
        parentNode.removeChild(previousNode);
        return true;
    }

    public static String getXmlString(Node rootNode, String xPath) throws Exception {
        XObject xobject = XPathAPI.eval((Node)rootNode, (String)xPath);
        NodeList componentList = xobject.nodelist();
        Node componentNode = componentList.item(0);
        StringWriter sw = new StringWriter();
        TransformerFactory tfFac = TransformerFactory.newInstance();
        Transformer tf = tfFac.newTransformer();
        tf.setOutputProperty("omit-xml-declaration", "yes");
        tf.transform(new DOMSource(componentNode), new StreamResult(sw));
        return sw.toString();
    }

    private static Document parsing(String filePath, boolean validating) throws Exception {
        try (FileInputStream in = null;){
            Document temp;
            File conf_file = new File(filePath);
            in = new FileInputStream(conf_file);
            if (conf_file == null || !conf_file.exists() || !conf_file.canRead()) {
                throw new FileNotFoundException();
            }
            Document document = temp = XmlUtil.parse(new BufferedInputStream(in), validating);
            return document;
        }
    }

    private static Document parsing(InputStream contents, boolean validating) throws Exception {
        try (FileInputStream in = null;){
            Document temp;
            in = (FileInputStream)contents;
            if (contents == null) {
                throw new FileNotFoundException();
            }
            Document document = temp = XmlUtil.parse(new BufferedInputStream(in), validating);
            return document;
        }
    }

    private static Document parsing(File file, boolean validating) throws Exception {
        try (FileInputStream in = null;){
            Document temp;
            File conf_file = file;
            in = new FileInputStream(conf_file);
            if (conf_file == null || !conf_file.exists() || !conf_file.canRead()) {
                throw new FileNotFoundException();
            }
            Document document = temp = XmlUtil.parse(new BufferedInputStream(in), validating);
            return document;
        }
    }

    private static Document parse(InputStream in, boolean validating) throws Exception {
        try {
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            return XmlUtil.createBuilder(validating).parse(is);
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        catch (SAXException sAXException) {
            throw new SAXException();
        }
    }

    private static DocumentBuilder createBuilder(boolean validating) throws Exception {
        try {
            DocumentBuilder builder = null;
            builder = validating ? vfactory.newDocumentBuilder() : factory.newDocumentBuilder();
            builder.setEntityResolver(null);
            return builder;
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParserConfigurationException();
        }
    }
}

