/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package egovframework.hdev.imp.ide.common;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**  
 * 리소스 정의 클래스
 * @Class Name : ResourceConstants
 * @Description : ResourceConstants Class
 * @Modification Information  
 * @
 * @  수정일			수정자		수정내용
 * @ ---------		---------	-------------------------------
 * @ 2012. 8. 22.		이율경		최초생성
 * 
 * @author 디바이스 API 개발환경 팀
 * @since 2012. 8. 22.
 * @version 1.0
 * @see
 * 
 */
public class ResourceConstants {

	/************************************************
	 *                  Web 관련
	 ************************************************/
    /** 제외 패스 */
    public static final IPath WEB_EXCLUDING_PATH = new Path("**"); 
    /** 소스 폴더 */
    public static final IPath WEB_SOURCE_FOLDER = new Path("src/main/java"); 
    /** 리소스 폴더 */
    public static final IPath WEB_RESOURCE_FOLDER = new Path("src/main/resources"); 

    /** 테스트 소스 폴더 */
    public static final IPath WEB_TEST_SOURCE_FOLDER = new Path("src/test/java"); 
    /** 테스트 리소스 폴더 */
    public static final IPath WEB_TEST_RESOURCE_FOLDER =
        new Path("src/test/resources"); 

    /** META-INF 경로 */
    public static final IPath WEB_METAINF_PATH = new Path("src/main/webapp/META-INF"); 
    /** WEB-INF 경로 */
    public static final IPath WEB_WEBINF_PATH = new Path("src/main/webapp/WEB-INF/"); 
    /** WEB-INF/lib 경로 */
    public static final IPath WEB_WEBINF_LIB_PATH = new Path("src/main/webapp/WEB-INF/lib"); 
    /** WEB-INF/classes 경로 */
    public static final IPath WEB_WEBINF_CLASSES_PATH = new Path("src/main/webapp/WEB-INF/classes"); 

    /** 기본 output 폴더 */
    public static final IPath WEB_DEFAULT_OUTPUT_FOLDER =
        new Path("target/classes"); 
    /** 테스트 output 폴더 */
    public static final IPath WEB_TEST_OUTPUT_FOLDER =
        new Path("target/test-classes"); 

    /** 웹 루트 */
    public static final String WEB_ROOT = "src/main/webapp"; 

    /** POM 파일명 */
    public static final String WEB_POM_FILENAME = "pom.xml"; 
    /** POM 예제 파일 경로 */
    public static final String WEB_POM_EXAMPLE_PATH =
        "egovframework/hdev/imp/ide/wizards/examples/web/"; 
    /** 예제 파일 경로 */
    public static final String WEB_EXAMPLES_PATH = "examples/web/";

    /** 시스템 폴더들 */
    public static final IPath[] WEB_SYSTEM_FOLDERS =
        {WEB_SOURCE_FOLDER, WEB_RESOURCE_FOLDER, WEB_TEST_SOURCE_FOLDER,
            WEB_TEST_RESOURCE_FOLDER, WEB_DEFAULT_OUTPUT_FOLDER, WEB_TEST_OUTPUT_FOLDER };
    /** 웹 어플리케이션 시스템 폴더들 */
    public static final IPath[] WEB_WEBAPP_SYSTEM_FOLDERS =
        {WEB_METAINF_PATH, WEB_WEBINF_PATH, WEB_WEBINF_LIB_PATH, WEB_WEBINF_CLASSES_PATH };
    
    /************************************************
	 *                  Android 관련
	 ************************************************/
    
    /** 제외 패스 */
    public static final IPath ANDROID_EXCLUDING_PATH = new Path("**"); 
    /** 소스 폴더 */
    public static final IPath ANDROID_SOURCE_FOLDER = new Path("src"); 
    /** assets 폴더 */
    public static final IPath ANDROID_ASSETS_FOLDER = new Path("assets");
    /** bin 폴더 */
    public static final IPath ANDROID_BIN_FOLDER = new Path("bin");
    /** bin/classes 폴더 */
    public static final IPath ANDROID_BIN_CLASSES_FOLDER = new Path("bin/classes");
    /** res 폴더 */
    public static final IPath ANDROID_RES_FOLDER = new Path("res");
    /** res/drawable-hdpi 폴더 */
    public static final IPath ANDROID_RES_DRAWABLE_HDPI_FOLDER = new Path("res/drawable-hdpi");
    /** res/drawable-ldpi 폴더 */
    public static final IPath ANDROID_RES_DRAWABLE_LDPI_FOLDER = new Path("res/drawable-ldpi");
    /** res/drawable-mdpi 폴더 */
    public static final IPath ANDROID_RES_DRAWABLE_MDPI_FOLDER = new Path("res/drawable-mdpi");
    /** res/layout 폴더 */
    public static final IPath ANDROID_RES_LAYOUT_FOLDER = new Path("res/layout");
    /** res/values 폴더 */
    public static final IPath ANDROID_RES_VALUES_FOLDER = new Path("res/values");
    
    /** 기본 output 폴더 */
    public static final IPath ANDROID_DEFAULT_OUTPUT_FOLDER = new Path("target/classes"); 
    /** 테스트 output 폴더 */
    public static final IPath ANDROID_TEST_OUTPUT_FOLDER = new Path("target/test-classes"); 

    /** POM 파일명 */
    public static final String ANDROID_POM_FILENAME = "pom.xml"; 
    /** POM 예제 파일 경로 */
    public static final String ANDROID_POM_EXAMPLE_PATH = "egovframework/hdev/imp/ide/wizards/examples/hyb/"; 
    
    /** SERVER INFO 경로 */
    public static final IPath DEVICEAPI_SERVER_INFO_PATH = new Path("res/values");;
    /** SERVER INFO 파일명 */
    public static final String DEVICEAPI_SERVER_INFO_FILENAME = "serverinfo.xml";
    /** SERVER INFO 예제 파일 경로 */
    public static final String DEVICEAPI_SERVER_INFO_EXAMPLE_PATH = "egovframework/hdev/imp/ide/wizards/examples/hyb/";
    
    /** ANDROID_FRAMEWORK */
    public static final IPath ANDROID_FRAMEWORK = new Path("com.android.ide.eclipse.adt.ANDROID_FRAMEWORK");
    
    /** ANDROID_LIBRARIES */
    public static final IPath ANDROID_LIBRARIES = new Path("com.android.ide.eclipse.adt.LIBRARIES");
    
    public static final IPath JAVA_CLASS_PATH_ENTRY = new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7");
    
    /** 시스템 폴더들 */
    public static final IPath[] ANDROID_SYSTEM_FOLDERS =
        {ANDROID_SOURCE_FOLDER, ANDROID_ASSETS_FOLDER, ANDROID_BIN_FOLDER,
    	ANDROID_BIN_CLASSES_FOLDER, ANDROID_RES_FOLDER, ANDROID_RES_DRAWABLE_HDPI_FOLDER, ANDROID_RES_DRAWABLE_LDPI_FOLDER, ANDROID_RES_DRAWABLE_MDPI_FOLDER, 
    	ANDROID_RES_LAYOUT_FOLDER, ANDROID_RES_VALUES_FOLDER, ANDROID_DEFAULT_OUTPUT_FOLDER, ANDROID_TEST_OUTPUT_FOLDER};
}
