/*
 * Decompiled with CFR 0.152.
 */
package egovframework.mdev.imp.commngt.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredCheckboxTree
extends FilteredTree {
    private WorkbenchJob refreshJob;

    public FilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, true);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new FilterableCheckboxTreeViewer(parent, style);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job;
        this.refreshJob = job = super.doCreateRefreshJob();
        return job;
    }

    public void resetFilter() {
        Text filterText = this.getFilterControl();
        if (filterText != null) {
            filterText.setText(this.initialText);
        }
        this.refreshJob.cancel();
        this.refreshJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    int getTreeLocationOffset() {
        GridLayout layout = (GridLayout)this.getLayout();
        int space = layout.horizontalSpacing + layout.marginTop + ((GridData)this.getLayoutData()).verticalIndent + 1;
        Text filterText = this.getFilterControl();
        if (filterText != null) {
            space += filterText.getSize().y;
        }
        return space;
    }

    public void clearText() {
        super.clearText();
    }

    public class FilterableCheckboxTreeViewer
    extends CheckboxTreeViewer {
        static final String NONE = "none";
        static final String CHECKED = "checked";
        static final String GREYED = "greyed";
        static final String CHECKED_GREYED = "checked_greyed";
        Map<Object, FilteredCheckboxTreeItem> itemCache;
        List<PreRefreshNotifier> refreshingListeners;

        protected void unmapAllElements() {
            this.itemCache = new HashMap<Object, FilteredCheckboxTreeItem>();
            super.unmapAllElements();
        }

        public FilterableCheckboxTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.itemCache = new HashMap<Object, FilteredCheckboxTreeItem>();
            this.refreshingListeners = new ArrayList<PreRefreshNotifier>();
            this.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    FilteredCheckboxTreeItem item = FilterableCheckboxTreeViewer.this.itemCache.get(event.getElement());
                    if (item != null) {
                        item.state = event.getChecked() ? FilterableCheckboxTreeViewer.CHECKED : FilterableCheckboxTreeViewer.NONE;
                    }
                }
            });
        }

        public void addPreRefreshNotifier(PreRefreshNotifier notifier) {
            if (this.refreshingListeners.contains(notifier)) {
                return;
            }
            this.refreshingListeners.add(notifier);
        }

        public boolean getChecked(Object element) {
            Widget testFindItem = FilteredCheckboxTree.this.getViewer().testFindItem(element);
            testFindItem = null;
            if (testFindItem == null && this.itemCache.containsKey(element)) {
                FilteredCheckboxTreeItem item = this.itemCache.get(element);
                if (item.state.equals(CHECKED)) {
                    return true;
                }
                if (item.state.equals(CHECKED_GREYED)) {
                    return true;
                }
                if (item.state.equals(GREYED)) {
                    return true;
                }
                if (item.state.equals(NONE)) {
                    return false;
                }
            }
            return super.getChecked(element);
        }

        public boolean getGrayChecked(Object element) {
            Widget testFindItem = FilteredCheckboxTree.this.getViewer().testFindItem(element);
            testFindItem = null;
            if (testFindItem == null) {
                if (this.itemCache.containsKey(element)) {
                    FilteredCheckboxTreeItem item = this.itemCache.get(element);
                    if (item.state.equals(CHECKED)) {
                        return false;
                    }
                    if (item.state.equals(CHECKED_GREYED)) {
                        return true;
                    }
                    if (item.state.equals(GREYED)) {
                        return false;
                    }
                    if (item.state.equals(NONE)) {
                        return false;
                    }
                } else if (super.getChecked(element) && super.getGrayed(element)) {
                    return true;
                }
            }
            return super.getChecked(element) && super.getGrayed(element);
        }

        public Object[] getCheckedChildren(Object element) {
            FilteredCheckboxTreeItem item = this.itemCache.get(element);
            ArrayList<Object> checkedChildren = new ArrayList<Object>();
            if (item != null) {
                List<FilteredCheckboxTreeItem> children = item.children;
                for (FilteredCheckboxTreeItem child : children) {
                    if (child.state != CHECKED) continue;
                    checkedChildren.add(child.data);
                }
            }
            return checkedChildren.toArray();
        }

        public Object[] getCheckedElements() {
            Iterator<FilteredCheckboxTreeItem> iterator = this.itemCache.values().iterator();
            LinkedList<Object> checkedElements = new LinkedList<Object>();
            while (iterator.hasNext()) {
                FilteredCheckboxTreeItem item = iterator.next();
                Widget testFindItem = FilteredCheckboxTree.this.getViewer().testFindItem(item.data);
                testFindItem = null;
                if (testFindItem == null) {
                    if (!item.state.equals(CHECKED) && !item.state.equals(CHECKED_GREYED) && !item.state.equals(GREYED)) continue;
                    checkedElements.add(item.data);
                    continue;
                }
                if (!((TreeItem)testFindItem).getChecked()) continue;
                checkedElements.add(testFindItem.getData());
            }
            return checkedElements.toArray();
        }

        public boolean setChecked(Object element, boolean state) {
            if (this.itemCache.containsKey(element)) {
                FilteredCheckboxTreeItem item = this.itemCache.get(element);
                item.state = state ? CHECKED : NONE;
            }
            return super.setChecked(element, state);
        }

        public void setCheckedElements(Object[] elements) {
            HashSet<Object> s = new HashSet<Object>(this.itemCache.keySet());
            s.removeAll(new HashSet<Object>(Arrays.asList(elements)));
            int i = 0;
            while (i < elements.length) {
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(elements[i]);
                if (filteredCheckboxTreeItem != null) {
                    filteredCheckboxTreeItem.state = CHECKED;
                }
                ++i;
            }
            for (Object e : s) {
                FilteredCheckboxTreeItem item = this.itemCache.get(e);
                if (item == null) continue;
                item.state = NONE;
            }
            super.setCheckedElements(elements);
        }

        public boolean setSubtreeChecked(Object element, boolean state) {
            String newState = state ? CHECKED : NONE;
            TreeItem item = (TreeItem)this.testFindItem(element);
            FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(element);
            if (item != null && filteredCheckboxTreeItem != null) {
                filteredCheckboxTreeItem.state = newState;
                TreeItem[] items = item.getItems();
                int i = 0;
                while (i < items.length) {
                    item = items[i];
                    if (item != null && (filteredCheckboxTreeItem = this.itemCache.get(item.getData())) != null) {
                        filteredCheckboxTreeItem.state = newState;
                    }
                    ++i;
                }
            }
            return super.setSubtreeChecked(element, state);
        }

        protected void preservingSelection(Runnable updateCode) {
            super.preservingSelection(updateCode);
            ArrayList<TreeItem> allTreeItems = this.getAllTreeItems(FilteredCheckboxTree.this.treeViewer.getTree().getItems());
            for (TreeItem item : allTreeItems) {
                this.doApplyCheckedState((Item)item, item.getData());
            }
            FilteredCheckboxTree.this.treeViewer.collapseAll();
            this.treeViewerExpand();
        }

        private void treeViewerExpand() {
            TreeItem[] items = FilteredCheckboxTree.this.treeViewer.getTree().getItems();
            int level = 1;
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.treeViewerExpand(item, level);
                ++n2;
            }
        }

        private void treeViewerExpand(TreeItem parentItem, int parentLevel) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = parentItem.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (this.getItemState(item).contains(CHECKED)) {
                    FilteredCheckboxTree.this.treeViewer.expandToLevel(parentItem.getData(), parentLevel);
                    break;
                }
                ++n2;
            }
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            String text = FilteredCheckboxTree.this.getFilterString();
            boolean initial = FilteredCheckboxTree.this.initialText != null && FilteredCheckboxTree.this.initialText.equals(text);
            boolean filtered = text.length() > 0 && !initial;
            for (PreRefreshNotifier notifier : this.refreshingListeners) {
                notifier.preRefresh(this, filtered);
            }
            this.saveCheckedState();
            super.internalRefresh(element, updateLabels);
            FilteredCheckboxTree.this.treeViewer.expandAll();
        }

        private void doApplyCheckedState(Item item, Object element) {
            super.doUpdateItem(item, element);
            TreeItem treeItem = (TreeItem)item;
            if (this.itemCache.containsKey(element)) {
                String state = this.itemCache.get((Object)element).state;
                if (state.equals(CHECKED_GREYED)) {
                    treeItem.setGrayed(true);
                    treeItem.setChecked(true);
                } else if (state.equals(CHECKED)) {
                    treeItem.setChecked(true);
                    treeItem.setGrayed(false);
                } else if (state.equals(GREYED)) {
                    treeItem.setGrayed(true);
                    treeItem.setChecked(false);
                } else {
                    treeItem.setGrayed(false);
                    treeItem.setChecked(false);
                }
            }
        }

        private ArrayList<TreeItem> getAllTreeItems(TreeItem[] roots) {
            ArrayList<TreeItem> list = new ArrayList<TreeItem>();
            int i = 0;
            while (i < roots.length) {
                TreeItem item = roots[i];
                list.add(item);
                list.addAll(this.getAllTreeItems(item.getItems()));
                ++i;
            }
            return list;
        }

        private void saveCheckedState() {
            TreeItem[] items = FilteredCheckboxTree.this.treeViewer.getTree().getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (!this.itemCache.containsKey(item.getData())) {
                    new FilteredCheckboxTreeItem(item.getData(), this.getItemState(item), this.itemCache, null);
                }
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(item.getData());
                filteredCheckboxTreeItem.state = this.getItemState(item);
                this.saveCheckedState(filteredCheckboxTreeItem, item);
                ++i;
            }
        }

        private void saveCheckedState(FilteredCheckboxTreeItem parent, TreeItem parentItem) {
            TreeItem[] items = parentItem.getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (!this.itemCache.containsKey(item.getData())) {
                    new FilteredCheckboxTreeItem(item.getData(), this.getItemState(item), this.itemCache, parent);
                }
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(item.getData());
                filteredCheckboxTreeItem.state = this.getItemState(item);
                this.saveCheckedState(filteredCheckboxTreeItem, item);
                ++i;
            }
        }

        private String getItemState(TreeItem item) {
            if (item.getChecked() && item.getGrayed()) {
                return CHECKED_GREYED;
            }
            if (item.getChecked()) {
                return CHECKED;
            }
            if (item.getGrayed()) {
                return GREYED;
            }
            return NONE;
        }

        class FilteredCheckboxTreeItem {
            Object data;
            String state;
            List<FilteredCheckboxTreeItem> children = new ArrayList<FilteredCheckboxTreeItem>();

            public FilteredCheckboxTreeItem(Object data, String state, Map<Object, FilteredCheckboxTreeItem> itemCache, FilteredCheckboxTreeItem parent) {
                this.data = data;
                this.state = state;
                itemCache.put(data, this);
                if (parent != null) {
                    parent.children.add(this);
                }
            }
        }
    }

    static interface PreRefreshNotifier {
        public void preRefresh(FilterableCheckboxTreeViewer var1, boolean var2);
    }
}

