/*
 * Decompiled with CFR 0.152.
 */
package egovframework.mdev.imp.commngt.wizards.operation;

import egovframework.mdev.imp.commngt.MobileComMngtPlugin;
import egovframework.mdev.imp.commngt.common.MobileComMngtLog;
import egovframework.mdev.imp.commngt.util.ComResourceUtilVO;
import egovframework.mdev.imp.commngt.util.ComResourceUtils;
import egovframework.mdev.imp.commngt.wizards.model.IComponentElement;
import egovframework.mdev.imp.commngt.wizards.model.MobileCommngtContext;
import egovframework.mdev.imp.commngt.wizards.pages.CustomizeTableCreationPage;
import egovframework.mdev.imp.ide.common.Policy;
import egovframework.mdev.imp.ide.common.ResourceUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ComponentAssembleOperation
implements IRunnableWithProgress {
    protected MobileCommngtContext context;
    CustomizeTableCreationPage datasourcePage;

    public ComponentAssembleOperation(MobileCommngtContext context) {
        this.context = context;
    }

    public void addComponent(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IFile file = null;
            List<IComponentElement> components = this.context.getComponent();
            IProject project = this.context.getJavaProject().getProject();
            String egovComponentInfo = "";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            Date dDate = new Date();
            String time = sdf.format(dDate);
            int i = 0;
            while (components.size() > i) {
                monitor.beginTask("", components.size() + 3);
                int work = 0;
                monitor.worked(++work);
                monitor.worked(++work);
                monitor.worked(++work);
                String fileName = "examples/" + components.get(i).getFileName();
                URL url = FileLocator.toFileURL((URL)MobileComMngtPlugin.getDefault().getBundle().getEntry(fileName));
                URL resolvedUrl = FileLocator.resolve((URL)url);
                ZipFile zipFile = new ZipFile(new File(resolvedUrl.getFile()), "UTF-8");
                Enumeration enumeration = zipFile.getEntries();
                ZipEntry entry = null;
                String type = null;
                String name = null;
                ComResourceUtilVO comVo = ComResourceUtils.getDispatcherAndContextLocation(this.context.getJavaProject());
                ComResourceUtilVO prefixVo = ComResourceUtils.getDispatcherPrefixLocation(this.context.getJavaProject(), comVo);
                while (enumeration.hasMoreElements()) {
                    entry = (ZipEntry)enumeration.nextElement();
                    name = entry.getName();
                    monitor.subTask("Install Mobile Common Component : " + name);
                    if (name != null && name.indexOf("/web.xml") > -1) {
                        type = "web.xml";
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            ComResourceUtils.copyWebXmlFile(this.context, (IContainer)project, entry.getName(), zipFile.getInputStream(entry), Policy.subMonitorFor((IProgressMonitor)monitor, (int)1), type);
                        }
                    } else if (name != null && name.indexOf("pom.xml") > -1) {
                        type = "pom.xml";
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            ComResourceUtils.modifyPom((IContainer)project, entry.getName(), zipFile.getInputStream(entry), Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                        }
                    } else if (name != null && name.indexOf("context-common.xml") > -1) {
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            boolean newComp = ComResourceUtils.modifyMessageSource((IContainer)project, entry.getName(), zipFile.getInputStream(entry), Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            boolean newLeavea = ComResourceUtils.modifyLeaverTraceSource((IContainer)project, entry.getName(), zipFile.getInputStream(entry), Policy.subMonitorFor((IProgressMonitor)monitor, (int)1), newComp);
                            if (!newComp && !newLeavea) {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName(), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            }
                        }
                    } else if (name != null && name.indexOf("context-validator.xml") > -1) {
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            boolean fileExist = ComResourceUtils.copyValidator((IContainer)project, entry.getName(), zipFile.getInputStream(entry), Policy.subMonitorFor((IProgressMonitor)monitor, (int)1), comVo);
                            if (!fileExist) {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName(), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            }
                        }
                    } else if (name != null && name.indexOf("egov-mcom-servlet.xml") > -1) {
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            if (file.isAccessible()) {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName(), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            } else {
                                ComResourceUtils.copyDispatcherServletFile(this.context, (IContainer)project, entry.getName(), zipFile.getInputStream(entry), Policy.subMonitorFor((IProgressMonitor)monitor, (int)1), comVo);
                            }
                        }
                    } else if (name != null && name.endsWith("index.jsp") && name.indexOf("WEB-INF") == -1) {
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            if (file.isAccessible()) {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName().replace("index.jsp", "m_index.jsp"), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            } else {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName(), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            }
                        }
                    } else if (name != null && name.endsWith(".jsp")) {
                        if (!entry.isDirectory()) {
                            file = project.getFile(entry.getName());
                            if (prefixVo == null || prefixVo.getPrefixPattern() == null) {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName(), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            } else {
                                ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName().replace("/WEB-INF/jsp/", prefixVo.getPrefixPattern()), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            }
                        }
                    } else if (!entry.isDirectory()) {
                        file = project.getFile(entry.getName());
                        ResourceUtils.createFolderFile((IContainer)project, (String)entry.getName(), (InputStream)zipFile.getInputStream(entry), (IProgressMonitor)Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                    }
                    type = "";
                }
                egovComponentInfo = String.valueOf(egovComponentInfo) + "\n[" + time + "] Installed component:\t" + components.get(i).getPackageName() + "\t" + components.get(i).getName();
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.worked(++work);
                ++i;
            }
            String egovComponentInfoFile = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/.metadata/.egovComponentInfo";
            try {
                File f = new File(egovComponentInfoFile);
                FileWriter fw = new FileWriter(f, true);
                fw.write(egovComponentInfo);
                fw.close();
            }
            catch (Exception exception) {}
            monitor.done();
        }
        catch (IOException ie) {
            MobileComMngtLog.logError(ie);
            throw new InvocationTargetException(ie);
        }
        catch (CoreException ce) {
            MobileComMngtLog.logCoreError(ce);
            throw new InvocationTargetException(ce);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.addComponent(monitor);
        if (this.context.getInstallType().indexOf("basic") > -1) {
            this.datasourcePage = new CustomizeTableCreationPage("insertDatasource", this.context);
            this.datasourcePage.performOk(monitor);
        }
        if (this.context.getInstallType().indexOf("user") > -1) {
            this.datasourcePage = new CustomizeTableCreationPage("insertDatasource", this.context);
            this.datasourcePage.performOk(monitor);
        }
    }
}

