/*
 * Decompiled with CFR 0.152.
 */
package egovframework.mdev.imp.commngt.wizards.pages;

import egovframework.mdev.imp.commngt.MobileComMngtPlugin;
import egovframework.mdev.imp.commngt.common.MobileComMngtMessages;
import egovframework.mdev.imp.commngt.util.FilteredCheckboxTree;
import egovframework.mdev.imp.commngt.util.FormBrowser;
import egovframework.mdev.imp.commngt.wizards.model.Category;
import egovframework.mdev.imp.commngt.wizards.model.Component;
import egovframework.mdev.imp.commngt.wizards.model.ComponentElementFactory;
import egovframework.mdev.imp.commngt.wizards.model.IComponentElement;
import egovframework.mdev.imp.commngt.wizards.model.MobileCommngtContext;
import egovframework.mdev.imp.commngt.wizards.pages.ComponentContentProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;

public class SelectCommonComponentPage
extends WizardPage
implements ModifyListener {
    private FilteredCheckboxTree.FilterableCheckboxTreeViewer treev = null;
    private FilteredCheckboxTree tree = null;
    protected FormBrowser descriptionBrowser;
    private final MobileCommngtContext context;
    private final ComponentElementFactory factory;
    private final ComponentContentProvider contentProvider = new ComponentContentProvider();
    private Text dependencyInfo = null;
    private String descDialog = "";
    private String compareProjectName = "";
    private Label projectName = null;

    public SelectCommonComponentPage(String pageName, MobileCommngtContext context) {
        super(pageName);
        this.context = context;
        this.setTitle(MobileComMngtMessages.selectComponentPagepageTitle);
        this.setDescription(MobileComMngtMessages.selectComponentPagepageDescription);
        this.descriptionBrowser = new FormBrowser(2560);
        this.factory = ComponentElementFactory.getInstance();
    }

    public void init() {
        List elements = (List)this.treev.getInput();
        if (elements == null) {
            return;
        }
        for (IComponentElement catElement : elements) {
            if (!(catElement instanceof Category)) continue;
            List<IComponentElement> components = ((Category)catElement).getChildren();
            for (IComponentElement comElement : components) {
                if (!(comElement instanceof Component) || !comElement.isCreatedComponent()) continue;
                this.treev.setGrayed(comElement, true);
                this.treev.setChecked(comElement, true);
                this.treev.expandToLevel(catElement, 1);
                List dependencylist = comElement.getDependencyPackage();
                for (Component dependency : dependencylist) {
                    if (dependency.isCreatedComponent() || this.treev.getChecked(dependency)) continue;
                    this.treev.setChecked(dependency, true);
                    dependency.setSelection(false);
                }
            }
        }
        this.parentNodeCheck();
        this.getCheckedComponents();
        this.projectName.forceFocus();
    }

    public boolean isPageComplete() {
        return this.context.getComponent() != null && this.context.getComponent().size() > 0;
    }

    public void modifyText(ModifyEvent e) {
        this.getWizard().getContainer().updateButtons();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createSelectComponentControls(container);
        this.setControl((Control)container);
        this.updatePageComplete();
    }

    public void createSelectComponentControls(Composite container) {
        Label label = new Label(container, 0);
        label.setText(MobileComMngtMessages.selectComponentPage3);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.projectName = new Label(container, 65);
        this.projectName.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        gd = new GridData(768);
        this.projectName.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(container, 256);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 2;
        sashForm.setLayoutData((Object)gd);
        Group treeGroup = new Group((Composite)sashForm, 0);
        treeGroup.setLayout((Layout)new GridLayout());
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        this.tree = new FilteredCheckboxTree((Composite)treeGroup, 2816, filter);
        this.treev = (FilteredCheckboxTree.FilterableCheckboxTreeViewer)this.tree.getViewer();
        this.treev.setContentProvider((IContentProvider)this.contentProvider);
        this.treev.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.treev.getTree().setLinesVisible(true);
        this.treev.getTree().setHeaderVisible(false);
        SashForm sashFormSub = new SashForm((Composite)sashForm, 512);
        gd = new GridData(1808);
        sashFormSub.setLayoutData((Object)gd);
        Group descriptionGroup = new Group((Composite)sashFormSub, 0);
        descriptionGroup.setLayout((Layout)new GridLayout());
        descriptionGroup.setText(MobileComMngtMessages.selectComponentPage0);
        this.createDescriptionIn((Composite)descriptionGroup);
        Group dependencyGroup = new Group((Composite)sashFormSub, 0);
        dependencyGroup.setLayout((Layout)new GridLayout());
        dependencyGroup.setText(MobileComMngtMessages.selectComponentPage1);
        this.dependencyInfo = new Text((Composite)dependencyGroup, 15);
        this.dependencyInfo.setLayoutData((Object)gd);
        this.dependencyInfo.setText("- N/A");
        this.treev.addSelectionChangedListener(new componentSelectionChangedListener());
        this.treev.addCheckStateListener(new componentCheckStateListener());
        Dialog.applyDialogFont((Control)container);
        Label note = new Label(container, 129);
        note.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        note.setText("Note:\n ");
        GridData gd2 = new GridData();
        gd2.verticalAlignment = 2;
        note.setLayoutData((Object)gd2);
        GridData gd4 = new GridData();
        gd4.verticalAlignment = 2;
        gd4.horizontalSpan = 2;
        gd4.heightHint = -1;
        gd4.horizontalIndent = 0;
        gd4.horizontalAlignment = 4;
        Label label1 = new Label(container, 0);
        label1.setText(MobileComMngtMessages.selectComponentPage2);
        label1.setLayoutData((Object)gd4);
        Label tmptmp3 = new Label(container, 0);
        tmptmp3.setText("");
        GridData tmp_gd13 = new GridData();
        tmptmp3.setLayoutData((Object)tmp_gd13);
        Label tmptmp4 = new Label(container, 0);
        tmptmp4.setText(MobileComMngtMessages.selectComponentPage7);
        GridData tmp_gd14 = new GridData();
        tmp_gd14.horizontalSpan = 2;
        tmp_gd14.horizontalAlignment = 16384;
        tmp_gd14.verticalAlignment = 1024;
        tmptmp4.setLayoutData((Object)tmp_gd14);
        Label tmptmp = new Label(container, 0);
        tmptmp.setText("");
        GridData tmp_gd11 = new GridData();
        tmptmp.setLayoutData((Object)tmp_gd11);
        Label tmptmp2 = new Label(container, 0);
        tmptmp2.setImage(MobileComMngtPlugin.getDefault().getImage(MobileComMngtPlugin.imgCommngtRemarks));
        GridData tmp_gd12 = new GridData();
        tmp_gd12.horizontalSpan = 2;
        tmp_gd12.horizontalAlignment = 16384;
        tmp_gd12.verticalAlignment = 1024;
        tmptmp2.setLayoutData((Object)tmp_gd12);
    }

    public void createDescriptionIn(Composite composite) {
        this.descriptionBrowser.createControl(composite);
        Control c = this.descriptionBrowser.getControl();
        GridData gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        this.descriptionBrowser.setText("- N/A");
    }

    private void updatePageComplete() {
        this.setPageComplete(false);
        if (this.isPageComplete()) {
            return;
        }
        this.setPageComplete(true);
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    public void dispose() {
        super.dispose();
    }

    public void parentNodeCheck() {
        List elements = (List)this.treev.getInput();
        String catStat = "";
        String nowStat = "";
        String beforeStat = "";
        IComponentElement children_now = null;
        IComponentElement children_before = null;
        if (elements == null) {
            return;
        }
        for (IComponentElement catElement : elements) {
            if (!(catElement instanceof Category)) continue;
            List<IComponentElement> components = ((Category)catElement).getChildren();
            Category cat = (Category)this.contentProvider.getParent((Component)components.get(0));
            catStat = "";
            nowStat = "";
            beforeStat = "";
            children_now = null;
            children_before = null;
            if (cat == null) continue;
            int i = 0;
            while (i < cat.getChildren().size()) {
                children_now = cat.getChildren().get(i);
                if (i > 0) {
                    children_before = cat.getChildren().get(i - 1);
                }
                nowStat = this.treev.getGrayed(children_now) && this.treev.getChecked(children_now) ? "graycheck" : (this.treev.getChecked(children_now) ? "check" : "none");
                if (children_before != null) {
                    beforeStat = this.treev.getGrayed(children_before) && this.treev.getChecked(children_before) ? "graycheck" : (this.treev.getChecked(children_before) ? "check" : "none");
                }
                if (i == 0) {
                    catStat = nowStat;
                } else {
                    if (nowStat.equals("none")) {
                        catStat = "none";
                        break;
                    }
                    if (!nowStat.equals(beforeStat)) {
                        catStat = "none";
                        break;
                    }
                    catStat = nowStat;
                }
                ++i;
            }
            if (catStat.equals("graycheck")) {
                this.treev.setGrayed(cat, true);
                this.treev.setChecked(cat, true);
                continue;
            }
            if (catStat.equals("none")) {
                this.treev.setGrayed(cat, false);
                this.treev.setChecked(cat, false);
                continue;
            }
            this.treev.setGrayed(cat, false);
            this.treev.setChecked(cat, true);
        }
    }

    public void checkDependency(Component checkedComponent) {
        List dependencylist = checkedComponent.getDependencyPackage();
        for (Component dependency : dependencylist) {
            if (dependency.isCreatedComponent() || this.treev.getChecked(dependency)) continue;
            this.treev.setChecked(dependency, true);
            dependency.setSelection(false);
        }
    }

    public void uncheckDependency(Component checkedComponent) {
        List dependencylist = checkedComponent.getDependencyPackage();
        for (Component dependency : dependencylist) {
            if (dependency.isCreatedComponent() || !this.treev.getChecked(dependency) || dependency.isSelection() || this.checkDependComponent2(dependency, dependencylist)) continue;
            this.treev.setChecked(dependency, false);
            dependency.setSelection(false);
        }
    }

    public int checkDependComponent(Component checkedComponent, List<Component> exceptDependency) {
        ArrayList<Component> exceptDependency_false = new ArrayList<Component>();
        if (exceptDependency != null) {
            for (Component exCom : exceptDependency) {
                if (exCom.isSelection()) continue;
                exceptDependency_false.add(exCom);
            }
        }
        int cnt = 0;
        this.descDialog = "";
        Object[] objectArray = this.getCheckedElements_all();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Component && ((Component)o).getDependencyPackage() != null && !checkedComponent.isCreatedComponent() && ((Component)o).getDependencyPackage().contains(checkedComponent)) {
                if (exceptDependency != null) {
                    if (!exceptDependency_false.contains((Component)o)) {
                        this.descDialog = ++cnt == 1 ? ((Component)o).getName() : String.valueOf(this.descDialog) + ", " + ((Component)o).getName();
                    }
                } else {
                    this.descDialog = ++cnt == 1 ? ((Component)o).getName() : String.valueOf(this.descDialog) + ", " + ((Component)o).getName();
                }
            }
            ++n2;
        }
        return cnt;
    }

    public boolean checkDependComponent2(Component checkedComponent, List<Component> exceptDependency) {
        Object[] oz;
        ArrayList<Component> exceptDependency_false = new ArrayList<Component>();
        if (exceptDependency != null) {
            for (Component exCom : exceptDependency) {
                if (exCom.isSelection()) continue;
                exceptDependency_false.add(exCom);
            }
        }
        Object[] objectArray = oz = this.getCheckedElements_all();
        int n = oz.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Component && ((Component)o).getDependencyPackage() != null && !checkedComponent.isCreatedComponent() && ((Component)o).getDependencyPackage().contains(checkedComponent)) {
                if (exceptDependency != null) {
                    if (!exceptDependency_false.contains((Component)o)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public Object[] getCheckedElements_all() {
        LinkedList<IComponentElement> checkedElements = new LinkedList<IComponentElement>();
        List items = (List)this.treev.getInput();
        for (IComponentElement item : items) {
            List<IComponentElement> components = ((Category)item).getChildren();
            for (IComponentElement comp : components) {
                if (!(comp instanceof Component) || !this.treev.getChecked(comp)) continue;
                checkedElements.add(comp);
            }
        }
        return checkedElements.toArray();
    }

    public void getCheckedComponents() {
        List tmp = (List)this.treev.getInput();
        ArrayList<IComponentElement> checkedComponents = new ArrayList<IComponentElement>();
        for (IComponentElement catElement : tmp) {
            if (!(catElement instanceof Category)) continue;
            List<IComponentElement> components = ((Category)catElement).getChildren();
            for (IComponentElement comElement : components) {
                if (!(comElement instanceof Component) || !this.treev.getChecked(comElement) || this.treev.getGrayChecked(comElement)) continue;
                checkedComponents.add(comElement);
            }
        }
        this.context.setComponent(checkedComponents);
        this.isPageComplete();
        this.updatePageComplete();
        if (this.context.getComponent() == null || this.context.getComponent().size() == 0) {
            this.setErrorMessage(MobileComMngtMessages.selectComponentPagepageDescription);
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    public void setVisible(boolean visible) {
        if (visible && this.context.getJavaProject() != null && !this.compareProjectName.equals(this.context.getJavaProject().getProject().getName())) {
            this.projectName.setText(this.context.getJavaProject().getProject().getName());
            this.factory.containsComponent(this.context.getJavaProject());
            this.treev.setInput(this.factory.getComponentElements());
            this.compareProjectName = this.context.getJavaProject().getProject().getName();
            this.init();
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        this.tree.clearText();
        super.setVisible(visible);
    }

    private class ComponentLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private final Color gray = new Color((Device)Display.getCurrent(), 110, 110, 110);

        private ComponentLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IComponentElement) {
                if (((IComponentElement)element).isCreatedComponent()) {
                    return String.valueOf(((IComponentElement)element).getName()) + "[Already Exist]";
                }
                return ((IComponentElement)element).getName();
            }
            return super.getText(element);
        }

        public Color getForeground(Object element) {
            if (element == null) {
                return null;
            }
            if (((IComponentElement)element).isCreatedComponent()) {
                return this.gray;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public void dispose() {
            this.gray.dispose();
        }
    }

    private class componentCheckStateListener
    implements ICheckStateListener {
        private componentCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event == null) {
                return;
            }
            final Object eventObj = event.getElement();
            if (event.getChecked()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (eventObj instanceof Category) {
                            SelectCommonComponentPage.this.treev.setSubtreeChecked(eventObj, true);
                            int exist_cnt = 0;
                            for (IComponentElement children : ((Category)eventObj).getChildren()) {
                                if (!(children instanceof Component)) continue;
                                SelectCommonComponentPage.this.treev.setGrayed(children, false);
                                ((Component)children).setSelection(true);
                                SelectCommonComponentPage.this.checkDependency((Component)children);
                                if (!children.isCreatedComponent()) continue;
                                ++exist_cnt;
                            }
                            if (exist_cnt > 0) {
                                MessageDialog.openInformation((Shell)SelectCommonComponentPage.this.getShell(), (String)MobileComMngtMessages.selectComponentPagedialogTitle, (String)MobileComMngtMessages.selectComponentPagedialog1);
                            }
                        } else {
                            ((Component)eventObj).setSelection(true);
                            SelectCommonComponentPage.this.checkDependency((Component)eventObj);
                        }
                    }
                };
                BusyIndicator.showWhile((Display)SelectCommonComponentPage.this.tree.getDisplay(), (Runnable)runnable);
            } else if (event.getElement() instanceof Category) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (SelectCommonComponentPage.this.treev.getGrayed((Category)eventObj)) {
                            SelectCommonComponentPage.this.treev.setSubtreeChecked(eventObj, true);
                            for (IComponentElement children : ((Category)eventObj).getChildren()) {
                                if (!(children instanceof Component)) continue;
                                SelectCommonComponentPage.this.treev.setGrayed(children, false);
                                ((Component)children).setSelection(true);
                                SelectCommonComponentPage.this.checkDependency((Component)children);
                            }
                            MessageDialog.openInformation((Shell)SelectCommonComponentPage.this.getShell(), (String)MobileComMngtMessages.selectComponentPagedialogTitle, (String)MobileComMngtMessages.selectComponentPagedialog1);
                        } else {
                            for (IComponentElement comp : ((Category)eventObj).getChildren()) {
                                if (!(comp instanceof Component)) continue;
                                if (comp.isCreatedComponent()) {
                                    if (SelectCommonComponentPage.this.treev.getGrayed(comp)) continue;
                                    SelectCommonComponentPage.this.treev.setGrayed(comp, true);
                                    SelectCommonComponentPage.this.treev.setChecked(comp, true);
                                    continue;
                                }
                                SelectCommonComponentPage.this.treev.setGrayed(comp, false);
                                SelectCommonComponentPage.this.treev.setChecked(comp, false);
                            }
                            boolean msg = false;
                            int cnt = 0;
                            for (IComponentElement comp2 : ((Category)eventObj).getChildren()) {
                                if (!(comp2 instanceof Component) || comp2.isCreatedComponent()) continue;
                                ((Component)comp2).setSelection(false);
                                SelectCommonComponentPage.this.uncheckDependency((Component)comp2);
                                boolean tmp = ((Component)comp2).isSelection();
                                if (!SelectCommonComponentPage.this.checkDependComponent2((Component)comp2, null)) continue;
                                msg = true;
                                ++cnt;
                                SelectCommonComponentPage.this.treev.setChecked((Component)comp2, true);
                                ((Component)comp2).setSelection(tmp);
                            }
                            if (msg) {
                                MessageDialog.openInformation((Shell)SelectCommonComponentPage.this.getShell(), (String)MobileComMngtMessages.selectComponentPagedialogTitle, (String)(String.valueOf(MobileComMngtMessages.selectComponentPagedialog3) + " " + cnt + MobileComMngtMessages.selectComponentPagedialog4));
                            }
                        }
                    }
                };
                BusyIndicator.showWhile((Display)SelectCommonComponentPage.this.tree.getDisplay(), (Runnable)runnable);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (((Component)eventObj).isCreatedComponent()) {
                            if (SelectCommonComponentPage.this.treev.getGrayed((Component)eventObj)) {
                                SelectCommonComponentPage.this.treev.setGrayed((Component)eventObj, false);
                                SelectCommonComponentPage.this.treev.setChecked((Component)eventObj, true);
                                ((Component)eventObj).setSelection(true);
                                MessageDialog.openInformation((Shell)SelectCommonComponentPage.this.getShell(), (String)MobileComMngtMessages.selectComponentPagedialogTitle, (String)MobileComMngtMessages.selectComponentPagedialog1);
                            } else {
                                SelectCommonComponentPage.this.treev.setGrayed((Component)eventObj, true);
                                SelectCommonComponentPage.this.treev.setChecked((Component)eventObj, true);
                                ((Component)eventObj).setSelection(false);
                            }
                        } else {
                            boolean tmp = ((Component)eventObj).isSelection();
                            if (SelectCommonComponentPage.this.checkDependComponent((Component)eventObj, ((Component)eventObj).getDependencyPackage()) > 0) {
                                MessageDialog.openInformation((Shell)SelectCommonComponentPage.this.getShell(), (String)MobileComMngtMessages.selectComponentPagedialogTitle, (String)(String.valueOf(MobileComMngtMessages.selectComponentPagedialog5) + " " + SelectCommonComponentPage.this.descDialog + MobileComMngtMessages.selectComponentPagedialog2));
                                SelectCommonComponentPage.this.treev.setChecked((Component)eventObj, true);
                                ((Component)eventObj).setSelection(tmp);
                            } else {
                                SelectCommonComponentPage.this.uncheckDependency((Component)eventObj);
                            }
                        }
                    }
                };
                BusyIndicator.showWhile((Display)SelectCommonComponentPage.this.tree.getDisplay(), (Runnable)runnable);
            }
            SelectCommonComponentPage.this.parentNodeCheck();
            SelectCommonComponentPage.this.getCheckedComponents();
        }
    }

    private class componentSelectionChangedListener
    implements ISelectionChangedListener {
        private componentSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() == null) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selected = selection.getFirstElement();
            if (selected == null) {
                return;
            }
            if (((IComponentElement)selected).getDesc() == null) {
                SelectCommonComponentPage.this.descriptionBrowser.setText("");
            } else {
                SelectCommonComponentPage.this.descriptionBrowser.setText(((IComponentElement)selected).getDesc() == null ? "" : ((IComponentElement)selected).getDesc());
            }
            String dString = "";
            if (selected instanceof Component) {
                List dependencylist = ((Component)selected).getDependencyPackage();
                if (dependencylist != null) {
                    int i = 0;
                    while (i < dependencylist.size()) {
                        dString = i == 0 ? (((Component)dependencylist.get(i)).getName() == "" ? "- N/A" : "- " + ((Component)dependencylist.get(i)).getParentName() + ">" + ((Component)dependencylist.get(i)).getName()) : String.valueOf(dString) + "\n- " + ((Component)dependencylist.get(i)).getParentName() + ">" + ((Component)dependencylist.get(i)).getName();
                        ++i;
                    }
                } else {
                    dString = "- N/A";
                }
            } else {
                dString = "- N/A";
            }
            SelectCommonComponentPage.this.dependencyInfo.setText(dString);
        }
    }
}

