/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db;

import java.util.HashMap;
import java.util.Map;
import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.sqleditor.EditorColorProvider;
import net.java.amateras.db.util.ColorRegistry;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DBPlugin
extends AbstractUIPlugin {
    public static final String PREF_VALIDATE_ON_SAVE = "pref_validate_on_save";
    public static final String PREF_VALIDATE_PHYSICAL_TABLE_NAME_REQUIRED = "pref_validate_physical_table_name_required";
    public static final String PREF_VALIDATE_PHYSICAL_TABLE_NAME_DUPLICATED = "pref_validate_physical_table_name_duplicated";
    public static final String PREF_VALIDATE_LOGICAL_TABLE_NAME_REQUIRED = "pref_validate_on_logical_table_name_required";
    public static final String PREF_VALIDATE_LOGICAL_TABLE_NAME_DUPLICATED = "pref_validate_on_logical_table_name_duplicated";
    public static final String PREF_VALIDATE_PHYSICAL_COLUMN_NAME_REQUIRED = "pref_validate_physical_column_name_required";
    public static final String PREF_VALIDATE_PHYSICAL_COLUMN_NAME_DUPLICATED = "pref_validate_physical_column_name_duplicatedl";
    public static final String PREF_VALIDATE_LOGICAL_COLUMN_NAME_REQUIRED = "pref_validate_physical_column_name_required";
    public static final String PREF_VALIDATE_LOGICAL_COLUMN_NAME_DUPLICATED = "pref_validate_physical_column_name_duplicated";
    public static final String PREF_VALIDATE_PRIMARY_KEY = "pref_validate_primary_key";
    public static final String PREF_VALIDATE_NO_COLUMNS = "pref_validate_on_columns";
    public static final String PREF_VALIDATE_FOREIGN_KEY_COLUMN_TYPE = "pref_validate_foreign_key_column_type";
    public static final String PREF_VALIDATE_FOREIGN_KEY_COLUMN_SIZE = "pref_validate_foreign_key_column_size";
    public static final String PREF_SHOW_GRID = "pref_show_grid";
    public static final String PREF_GRID_SIZE = "pref_grid_size";
    public static final String PREF_SNAP_GEOMETRY = "pref_snap_geometry";
    public static final String PREF_SHOW_NOT_NULL = "pref_show_notnull";
    public static final String PREF_FONT = "pref_font";
    public static final String PREF_DICTIONALY = "pref_dictionary";
    public static final String PREF_COLOR_DEFAULT = "colorDefault";
    public static final String PREF_COLOR_COMMENT = "colorComment";
    public static final String PREF_COLOR_STRING = "colorString";
    public static final String PREF_COLOR_KEYWORD = "colorKeyword";
    public static final String LEVEL_ERROR = "ERROR";
    public static final String LEVEL_WARNING = "WARNING";
    public static final String LEVEL_IGNORE = "IGNORE";
    private static DBPlugin plugin;
    public static final String PLUGIN_ID = "net.java.amateras.db";
    private Map<String, IDialect> contributedDialects = null;
    private ColorRegistry colorRegistry = new ColorRegistry();
    private EditorColorProvider colorProvider;
    public static final String ICON_TABLE = "icons/table.gif";
    public static final String ICON_COLUMN = "icons/column.gif";
    public static final String ICON_PK_COLUMN = "icons/pk_column.gif";
    public static final String ICON_INDEX = "icons/index.gif";
    public static final String ICON_FOLDER = "icons/folder.gif";
    public static final String ICON_DOMMAIN = "icons/domain.gif";
    public static final String ICON_ERROR = "icons/error.gif";
    public static final String ICON_WARNING = "icons/warning.gif";
    public static final String ICON_OVERLAY_ERROR = "icons/ovr_error.gif";
    public static final String ICON_OVERLAY_WARNING = "icons/ovr_warning.gif";
    public static final String ICON_REFRESH = "icons/refresh.gif";

    public DBPlugin() {
        plugin = this;
    }

    public static String getResourceString(String key) {
        return Messages.getResourceString(key);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.colorProvider = new EditorColorProvider(this.getPreferenceStore());
    }

    public static Image getImage(String path) {
        ImageRegistry images = DBPlugin.getDefault().getImageRegistry();
        Image image = images.get(path);
        if (image == null) {
            image = DBPlugin.getImageDescriptor(path).createImage();
            images.put(path, image);
        }
        return image;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DBPlugin.this.getImageRegistry().dispose();
                DBPlugin.this.colorRegistry.dispose();
            }
        });
        plugin = null;
    }

    public static DBPlugin getDefault() {
        return plugin;
    }

    public Color getColor(RGB rgb) {
        return this.colorRegistry.getColor(rgb);
    }

    public EditorColorProvider getEditorColorProvider() {
        return this.colorProvider;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void logException(Exception ex) {
        Status status = new Status(4, PLUGIN_ID, 4, "Error", (Throwable)ex);
        DBPlugin.getDefault().getLog().log((IStatus)status);
        ex.printStackTrace();
    }

    public String createMessage(String key, String[] values) {
        String message = DBPlugin.getResourceString(key);
        int i = 0;
        while (i < values.length) {
            message = message.replaceAll("\\{" + i + "\\}", values[i]);
            ++i;
        }
        return message;
    }

    public Map<String, IDialect> getContributedDialects() {
        if (this.contributedDialects == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("net.java.amateras.db.dialects");
            IExtension[] extensions = point.getExtensions();
            this.contributedDialects = new HashMap<String, IDialect>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        if ("dialect".equals(elements[j].getName())) {
                            String name = elements[j].getAttribute("name");
                            IDialect dialect = (IDialect)elements[j].createExecutableExtension("class");
                            this.contributedDialects.put(name, dialect);
                        }
                    }
                    catch (Exception ex) {
                        DBPlugin.logException(ex);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.contributedDialects;
    }
}

