/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.validator.DiagramErrors;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class DB2Dialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("INTEGER", Messages.getResourceString("type.integer"), false, 4), new ColumnType("BIGINT", Messages.getResourceString("type.integer"), false, -5), new ColumnType("SMALLINT", Messages.getResourceString("type.integer"), false, 5), new ColumnType("NUMERIC", Messages.getResourceString("type.numeric"), true, 2), new ColumnType("REAL", Messages.getResourceString("type.bit"), false, 6), new ColumnType("DOUBLE", Messages.getResourceString("type.real"), false, 8), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("CLOB", Messages.getResourceString("type.string"), true, 2005), new ColumnType("DATE", Messages.getResourceString("type.date"), false, 91), new ColumnType("TIME", Messages.getResourceString("type.date"), false, 92), new ColumnType("TIMESTAMP", Messages.getResourceString("type.date"), false, 93), new ColumnType("BLOB", Messages.getResourceString("type.binary"), true, 2004)};

    public DB2Dialect() {
        super(COLUMN_TYPES);
    }

    @Override
    public void validate(DiagramErrors errors, RootModel model) {
        for (AbstractDBEntityModel entity : model.getChildren()) {
            if (!(entity instanceof TableModel)) continue;
            TableModel table = (TableModel)entity;
            String tableName = table.getTableName();
            if (tableName.length() > 30) {
                errors.addError("ERROR", table, DBPlugin.getResourceString("validation.error.oracle.tableNameLength"));
            }
            Object[] objectArray = table.getColumns();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnModel column = objectArray[n2];
                String columnName = column.getColumnName();
                if (columnName.length() > 30) {
                    errors.addError("ERROR", table, column, DBPlugin.getResourceString("validation.error.oracle.columnNameLength"));
                }
                ++n2;
            }
            objectArray = table.getIndices();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object index = objectArray[n2];
                String indexName = ((IndexModel)index).getIndexName();
                if (indexName.length() > 30) {
                    errors.addError("ERROR", table, (IndexModel)index, DBPlugin.getResourceString("validation.error.oracle.indexNameLength"));
                }
                ++n2;
            }
        }
    }
}

