/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class H2Dialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("INT", Messages.getResourceString("type.integer"), false, 4), new ColumnType("INTEGER", Messages.getResourceString("type.integer"), false, 4), new ColumnType("BOOLEAN", Messages.getResourceString("type.boolean"), false, 16), new ColumnType("BIT", Messages.getResourceString("type.boolean"), false, 16), new ColumnType("BOOL", Messages.getResourceString("type.boolean"), false, 16), new ColumnType("TINYINT", Messages.getResourceString("type.integer"), false, -6), new ColumnType("BIGINT", Messages.getResourceString("type.integer"), false, -5), new ColumnType("DECIMAL", Messages.getResourceString("type.numeric"), true, 3), new ColumnType("NUMBER", Messages.getResourceString("type.numeric"), true, 3), new ColumnType("NUMERIC", Messages.getResourceString("type.numeric"), true, 3), new ColumnType("DOUBLE", Messages.getResourceString("type.real"), false, 8), new ColumnType("FLOAT", Messages.getResourceString("type.real"), false, 8), new ColumnType("REAL", Messages.getResourceString("type.real"), false, 7), new ColumnType("TIME", Messages.getResourceString("type.time"), false, 92), new ColumnType("DATE", Messages.getResourceString("type.date"), false, 91), new ColumnType("TIMESTAMP", Messages.getResourceString("type.datetime"), false, 93), new ColumnType("DATETIME", Messages.getResourceString("type.datetime"), false, 93), new ColumnType("BINATY", Messages.getResourceString("type.binary"), true, -2), new ColumnType("OBJECT", Messages.getResourceString("type.object"), false, 1111), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("VARCHAR_CASESENSITIVE", Messages.getResourceString("type.string"), true, 12), new ColumnType("VARCHAR_IGNORECASE", Messages.getResourceString("type.string"), true, 12), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("CHARACTER", Messages.getResourceString("type.char"), true, 1), new ColumnType("BLOB", Messages.getResourceString("type.binary"), false, 2004), new ColumnType("CLOB", Messages.getResourceString("type.string"), true, 2005), new ColumnType("TEXT", Messages.getResourceString("type.string"), true, 2005), new ColumnType("ARRAY", Messages.getResourceString("type.string"), true, 2003)};

    public H2Dialect() {
        super(COLUMN_TYPES);
    }

    @Override
    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions, boolean comment) {
        StringBuffer sb = new StringBuffer();
        sb.append(columnModel.getColumnName());
        if (columnModel.isAutoIncrement()) {
            sb.append(" IDENTITY");
        } else {
            sb.append(" ").append(columnModel.getColumnType().getName());
            if (columnModel.getColumnType().supportSize() && columnModel.getSize().length() > 0) {
                sb.append("(").append(columnModel.getSize()).append(")");
            }
        }
        if (columnModel.getDefaultValue().length() != 0) {
            sb.append(" DEFAULT ").append(columnModel.getDefaultValue());
        }
        if (columnModel.isNotNull()) {
            sb.append(" NOT NULL");
        }
        if (columnModel.isPrimaryKey() && !alterTable && tableModel.getPrimaryKeyColumns().length == 1) {
            sb.append(" PRIMARY KEY");
        }
        return sb.toString();
    }

    @Override
    public String getColumnMetadataSQL(String tableName) {
        return String.valueOf(super.getColumnMetadataSQL(tableName)) + "  LIMIT 1";
    }
}

