/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class MSSQLDialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("BIT", Messages.getResourceString("type.bit"), false, -7), new ColumnType("INT", Messages.getResourceString("type.integer"), false, 4), new ColumnType("BIGINT", Messages.getResourceString("type.integer"), false, -5), new ColumnType("SMALLINT", Messages.getResourceString("type.integer"), false, 5), new ColumnType("TINYINT", Messages.getResourceString("type.integer"), false, -6), new ColumnType("DECIMAL", Messages.getResourceString("type.numeric"), false, 3), new ColumnType("NUMERIC", Messages.getResourceString("type.numeric"), false, 2), new ColumnType("MONEY", Messages.getResourceString("type.money"), false, 3), new ColumnType("SMALLMONEY", Messages.getResourceString("type.money"), false, 3), new ColumnType("FLOAT", Messages.getResourceString("type.real"), true, 6), new ColumnType("REAL", Messages.getResourceString("type.real"), false, 7), new ColumnType("DATETIME", Messages.getResourceString("type.date"), false, 91), new ColumnType("SMALLDATETIME", Messages.getResourceString("type.date"), false, 91), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("TEXT", Messages.getResourceString("type.text"), false, 12), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("NCHAR", String.valueOf(Messages.getResourceString("type.char")) + Messages.getResourceString("type.unicode"), true, -15), new ColumnType("NTEXT", String.valueOf(Messages.getResourceString("type.text")) + Messages.getResourceString("type.unicode"), false, 12), new ColumnType("NVARCHAR", String.valueOf(Messages.getResourceString("type.string")) + Messages.getResourceString("type.unicode"), true, -9), new ColumnType("BINARY", Messages.getResourceString("type.binary"), true, 2004), new ColumnType("VARBINARY", Messages.getResourceString("type.binary"), true, 2004), new ColumnType("TIMESTAMP", Messages.getResourceString("type.timestamp"), false, -2), new ColumnType("SQL_VARIANT", Messages.getResourceString("type.variant"), false, 1111), new ColumnType("UNIQUEIDENTIFIER", Messages.getResourceString("type.guid"), false, 1111), new ColumnType("XML", Messages.getResourceString("type.xml"), false, 1111)};

    public MSSQLDialect() {
        super(COLUMN_TYPES, String.valueOf(LS) + "go");
    }

    @Override
    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions, boolean comment) {
        String ddl = super.createColumnDDL(root, tableModel, columnModel, schema, alterTable, additions, comment);
        if (columnModel.isAutoIncrement()) {
            ddl = String.valueOf(ddl) + " IDENTITY";
        }
        return ddl;
    }

    @Override
    public String getColumnMetadataSQL(String tableName) {
        return "SELECT TOP 1 * FROM " + tableName;
    }
}

