/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class MySQLDialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("BOOL", Messages.getResourceString("type.boolean"), false, 16), new ColumnType("BOOLEAN", Messages.getResourceString("type.boolean"), false, 16), new ColumnType("BIT", Messages.getResourceString("type.bit"), false, -7), new ColumnType("TINYINT", Messages.getResourceString("type.integer"), true, -6), new ColumnType("SMALLINT", Messages.getResourceString("type.integer"), true, 5), new ColumnType("MEDIUMINT", Messages.getResourceString("type.integer"), true, 4), new ColumnType("INT", Messages.getResourceString("type.integer"), true, 4), new ColumnType("INTEGER", Messages.getResourceString("type.integer"), true, 4), new ColumnType("BIGINT", Messages.getResourceString("type.integer"), true, -5), new ColumnType("FLOAT", Messages.getResourceString("type.real"), true, 6), new ColumnType("DOUBLE", Messages.getResourceString("type.real"), true, 8), new ColumnType("DECIMAL", Messages.getResourceString("type.real"), true, 3), new ColumnType("DEC", Messages.getResourceString("type.real"), true, 3), new ColumnType("DATE", Messages.getResourceString("type.date"), false, 91), new ColumnType("DATETIME", Messages.getResourceString("type.datetime"), false, 91), new ColumnType("TIME", Messages.getResourceString("type.time"), false, 92), new ColumnType("TIMESTAMP", Messages.getResourceString("type.datetime"), false, 93), new ColumnType("YEAR", Messages.getResourceString("type.year"), false, 4), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("CHARACTER", Messages.getResourceString("type.char"), true, 1), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("BINARY", Messages.getResourceString("type.binary"), true, -2), new ColumnType("VARBINARY", Messages.getResourceString("type.binary"), true, -3), new ColumnType("BLOB", Messages.getResourceString("type.binary"), false, 2004), new ColumnType("TINYTEXT", Messages.getResourceString("type.string"), false, 12), new ColumnType("TEXT", Messages.getResourceString("type.string"), false, 12), new ColumnType("MEDIUMTEXT", Messages.getResourceString("type.string"), false, 12), new ColumnType("LONGTEXT", Messages.getResourceString("type.string"), false, 12)};

    public MySQLDialect() {
        super(COLUMN_TYPES);
    }

    @Override
    protected void setupTableOption(RootModel root, TableModel model, boolean schema, boolean drop, boolean alterTable, boolean comment, StringBuilder additions, StringBuffer sb) {
        super.setupTableOption(root, model, schema, drop, alterTable, comment, additions, sb);
        if (comment && model.getLogicalName() != null && model.getLogicalName().length() > 0) {
            sb.append(" COMMENT='").append(model.getLogicalName()).append("'");
        }
    }

    @Override
    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions, boolean comment) {
        String ddl = super.createColumnDDL(root, tableModel, columnModel, schema, alterTable, additions, comment);
        if (columnModel.isAutoIncrement()) {
            ddl = String.valueOf(ddl) + " AUTO_INCREMENT";
        }
        if (comment && columnModel.getLogicalName() != null && columnModel.getLogicalName().length() > 0) {
            ddl = String.valueOf(ddl) + " COMMENT '" + columnModel.getLogicalName() + "'";
        }
        return ddl;
    }

    @Override
    public String getColumnMetadataSQL(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0, 1";
    }

    @Override
    protected void createDropTableStatement(StringBuilder sb, String tableName) {
        sb.append("DROP TABLE IF EXISTS ").append(tableName).append(";");
    }
}

