/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.ISchemaLoader;
import net.java.amateras.db.dialect.OracleSchemaLoader;
import net.java.amateras.db.validator.DiagramErrors;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class OracleDialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("NUMBER", Messages.getResourceString("type.numeric"), true, 2), new ColumnType("INTEGER", Messages.getResourceString("type.integer"), true, 4), new ColumnType("BINARY_FLOAT", Messages.getResourceString("type.bit"), false, 6), new ColumnType("DOUBLE PRECISION", Messages.getResourceString("type.real"), false, 8), new ColumnType("VARCHAR2", Messages.getResourceString("type.string"), true, 12), new ColumnType("CHAR", Messages.getResourceString("type.char"), true, 1), new ColumnType("CLOB", Messages.getResourceString("type.string"), true, 2005), new ColumnType("LONG", Messages.getResourceString("type.string"), false, 2005), new ColumnType("DATE", Messages.getResourceString("type.date"), false, 91), new ColumnType("TIMESTAMP", Messages.getResourceString("type.date"), true, 93), new ColumnType("RAW", Messages.getResourceString("type.binary"), false, -2), new ColumnType("BLOB", Messages.getResourceString("type.binary"), false, 2004)};

    public OracleDialect() {
        super(COLUMN_TYPES);
    }

    @Override
    public ISchemaLoader getSchemaLoader() {
        return new OracleSchemaLoader();
    }

    @Override
    public String createTableDDL(RootModel root, TableModel model, boolean schema, boolean drop, boolean alterTable, boolean comment, StringBuilder additions) {
        String ddl = super.createTableDDL(root, model, schema, drop, alterTable, comment, additions);
        StringBuilder sb = new StringBuilder();
        StringBuilder sbComment = new StringBuilder();
        if (comment) {
            sbComment.append("COMMENT ON TABLE ").append(model.getTableName()).append(" is ");
            sbComment.append("'").append(model.getLogicalName()).append("';");
            sbComment.append(LS);
        }
        ColumnModel[] columnModelArray = model.getColumns();
        int n = columnModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnModel column = columnModelArray[n2];
            if (column.isAutoIncrement()) {
                String seqName = String.valueOf(model.getTableName()) + "_" + column.getColumnName() + "_SEQ";
                String triggerName = String.valueOf(model.getTableName()) + "_" + column.getColumnName() + "_TRG";
                if (drop) {
                    sb.append("DROP SEQUENCE ").append(seqName).append(";").append(LS);
                    sb.append(LS);
                }
                sb.append("CREATE SEQUENCE ");
                sb.append(seqName);
                sb.append(" NOMAXVALUE NOCACHE NOORDER NOCYCLE;").append(LS);
                sb.append(LS);
                sb.append("CREATE TRIGGER ");
                sb.append(triggerName).append(LS);
                sb.append("BEFORE INSERT ON ").append(model.getTableName()).append(LS);
                sb.append("FOR EACH ROW").append(LS);
                sb.append("BEGIN").append(LS);
                sb.append("IF :NEW.").append(column.getColumnName()).append(" IS NOT NULL THEN").append(LS);
                sb.append("  SELECT ").append(seqName).append(".NEXTVAL ");
                sb.append("INTO :NEW.").append(column.getColumnName()).append(" FROM DUAL;").append(LS);
                sb.append("END IF;").append(LS);
                sb.append("END;").append(LS);
            }
            if (comment && column.getLogicalName() != null && column.getLogicalName().length() > 0) {
                sbComment.append("COMMENT ON COLUMN ").append(model.getTableName()).append(".");
                sbComment.append(column.getColumnName()).append(" is ");
                sbComment.append("'").append(column.getLogicalName()).append("';");
                sbComment.append(LS);
            }
            ++n2;
        }
        if (sb.length() > 0) {
            ddl = String.valueOf(ddl) + LS + sb.toString();
        }
        if (sbComment.length() > 0) {
            ddl = String.valueOf(ddl) + LS + sbComment.toString();
        }
        ddl = String.valueOf(ddl) + LS;
        return ddl;
    }

    @Override
    public void validate(DiagramErrors errors, RootModel model) {
        for (AbstractDBEntityModel entity : model.getChildren()) {
            if (!(entity instanceof TableModel)) continue;
            TableModel table = (TableModel)entity;
            String tableName = table.getTableName();
            if (tableName.length() > 30) {
                errors.addError("ERROR", table, DBPlugin.getResourceString("validation.error.oracle.tableNameLength"));
            }
            Object[] objectArray = table.getColumns();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnModel column = objectArray[n2];
                String columnName = column.getColumnName();
                if (columnName.length() > 30) {
                    errors.addError("ERROR", table, column, DBPlugin.getResourceString("validation.error.oracle.columnNameLength"));
                }
                ++n2;
            }
            objectArray = table.getIndices();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object index = objectArray[n2];
                String indexName = ((IndexModel)index).getIndexName();
                if (indexName.length() > 30) {
                    errors.addError("ERROR", table, (IndexModel)index, DBPlugin.getResourceString("validation.error.oracle.indexNameLength"));
                }
                ++n2;
            }
        }
    }

    @Override
    protected void createDropTableStatement(StringBuilder sb, String tableName) {
        sb.append("DROP TABLE ").append(tableName).append(" CASCADE CONSTRAINTS;");
    }

    @Override
    public String getColumnMetadataSQL(String tableName) {
        return "SELECT * FROM " + tableName + " WHERE ROWNUM = 1";
    }
}

