/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.dialect.DefaultSchemaLoader;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.dialect.IndexType;
import net.java.amateras.db.util.StringUtils;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.TableModel;

public class OracleSchemaLoader
extends DefaultSchemaLoader {
    @Override
    protected TableModel getTableInfo(String tableName, IDialect dialect, Connection conn, String catalog, String schema, boolean autoConvert) throws SQLException {
        TableModel table = new TableModel();
        table.setTableName(tableName);
        if (autoConvert) {
            table.setLogicalName(table.getTableName());
        } else {
            table.setLogicalName(this.getTableComment(tableName, conn, catalog, schema));
        }
        DatabaseMetaData meta = conn.getMetaData();
        ArrayList<ColumnModel> list = new ArrayList<ColumnModel>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(dialect.getColumnMetadataSQL(this.getTableName(tableName, schema)));
        ResultSetMetaData rm = rs.getMetaData();
        ResultSet columns = meta.getColumns(catalog, schema, tableName, "%");
        while (columns.next()) {
            IColumnType type = dialect.getColumnType(columns.getString("TYPE_NAME"));
            if (type == null && (type = dialect.getColumnType(columns.getInt("DATA_TYPE"))) == null) {
                type = dialect.getDefaultColumnType();
            }
            ColumnModel column = new ColumnModel();
            column.setColumnName(columns.getString("COLUMN_NAME"));
            if (autoConvert) {
                column.setLogicalName(column.getColumnName());
            } else {
                column.setLogicalName(this.getColumnComment(tableName, columns.getString("COLUMN_NAME"), conn, catalog, schema));
            }
            column.setColumnType(type);
            column.setSize(columns.getString("COLUMN_SIZE"));
            column.setNotNull(columns.getString("IS_NULLABLE").equals("NO"));
            int rmIndex = this.getResultSetMetaDataIndex(rm, column.getColumnName());
            if (rmIndex > 0) {
                column.setAutoIncrement(rm.isAutoIncrement(rmIndex));
            }
            list.add(column);
        }
        columns.close();
        ResultSet keys = meta.getPrimaryKeys(catalog, schema, tableName);
        while (keys.next()) {
            String columnName = keys.getString("COLUMN_NAME");
            int i = 0;
            while (i < list.size()) {
                ColumnModel column = (ColumnModel)list.get(i);
                if (column.getColumnName().equals(columnName)) {
                    column.setPrimaryKey(true);
                }
                ++i;
            }
        }
        keys.close();
        rs.close();
        stmt.close();
        table.setColumns(list.toArray(new ColumnModel[list.size()]));
        List<IndexModel> indices = this.loadIndexModels(tableName, dialect, conn, catalog, schema, list);
        table.setIndices(indices.toArray(new IndexModel[indices.size()]));
        return table;
    }

    @Override
    protected List<IndexModel> loadIndexModels(String tableName, IDialect dialect, Connection conn, String catalog, String schema, List<ColumnModel> columns) throws SQLException {
        ArrayList<IndexModel> result = new ArrayList<IndexModel>();
        ResultSet rs = this.getIndexInfo(conn, schema, tableName);
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null) continue;
            IndexModel indexModel = null;
            for (IndexModel index : result) {
                if (!index.getIndexName().equals(indexName)) continue;
                indexModel = index;
                break;
            }
            if (indexModel == null) {
                indexModel = new IndexModel();
                indexModel.setIndexName(indexName);
                indexModel.setIndexName(rs.getString("INDEX_NAME"));
                if (rs.getBoolean("NON_UNIQUE")) {
                    indexModel.setIndexType(new IndexType("INDEX"));
                } else {
                    indexModel.setIndexType(new IndexType("UNIQUE"));
                }
                result.add(indexModel);
            }
            indexModel.getColumns().add(rs.getString("COLUMN_NAME"));
        }
        rs.close();
        ArrayList<IndexModel> removeIndexModels = new ArrayList<IndexModel>();
        for (IndexModel indexModel : result) {
            ArrayList<String> pkColumns = new ArrayList<String>();
            for (ColumnModel columnModel : columns) {
                if (!columnModel.isPrimaryKey()) continue;
                pkColumns.add(columnModel.getColumnName());
            }
            if (indexModel.getColumns().size() != pkColumns.size()) continue;
            boolean isNotPk = false;
            int i = 0;
            while (i < indexModel.getColumns().size()) {
                if (!indexModel.getColumns().get(i).equals(pkColumns.get(i))) {
                    isNotPk = true;
                    break;
                }
                ++i;
            }
            if (isNotPk) continue;
            removeIndexModels.add(indexModel);
        }
        result.removeAll(removeIndexModels);
        return result;
    }

    private ResultSet getIndexInfo(Connection conn, String schema, String tableName) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT NULL                                     AS table_cat\t\t\t\t");
        query.append("\t    ,i.owner                                  AS table_schem            ");
        query.append("\t    ,i.table_name                             AS table_name             ");
        query.append("\t    ,decode(i.uniqueness ,'UNIQUE' ,0 ,1)     AS non_unique             ");
        query.append("\t    ,NULL                                     AS index_qualifier        ");
        query.append("\t    ,i.index_name                             AS index_name             ");
        query.append("\t    ,1                                        AS type                   ");
        query.append("\t    ,c.column_position                        AS ordinal_position       ");
        query.append("\t    ,c.column_name                            AS column_name            ");
        query.append("\t    ,NULL                                     AS asc_or_desc            ");
        query.append("\t    ,i.distinct_keys                          AS cardinality            ");
        query.append("\t    ,i.leaf_blocks                            AS pages                  ");
        query.append("\t    ,NULL                                     AS filter_condition       ");
        query.append("  FROM all_indexes     i                                                  ");
        query.append("\t    ,all_ind_columns c                                                  ");
        query.append(" WHERE i.table_name    = ?                                    \t\t\t");
        if (StringUtils.isNotEmpty(schema)) {
            query.append("   AND i.owner         = ?                                          \t\t");
        } else {
            query.append("   AND i.owner         = USER                                        \t\t");
        }
        query.append("   AND i.index_name    = c.index_name                                     ");
        query.append("   AND i.table_owner   = c.table_owner                                    ");
        query.append("   AND i.table_name    = c.table_name                                     ");
        query.append("   AND i.owner         = c.index_owner                                    ");
        query.append(" ORDER BY non_unique ,type ,index_name ,ordinal_position                  ");
        PreparedStatement pstmt = conn.prepareStatement(query.toString());
        pstmt.setString(1, tableName.toUpperCase());
        if (StringUtils.isNotEmpty(schema)) {
            pstmt.setString(2, schema.toUpperCase());
        }
        return pstmt.executeQuery();
    }

    private String getTableName(String tabName, String schema) {
        if (StringUtils.isNotEmpty(schema)) {
            return String.valueOf(schema) + "." + tabName;
        }
        return tabName;
    }

    protected String getTableComment(String tableName, Connection conn, String catalog, String schema) throws SQLException {
        ResultSet rs;
        String comment = tableName;
        StringBuffer query = new StringBuffer();
        query.append("SELECT COMMENTS FROM ALL_TAB_COMMENTS WHERE TABLE_NAME = ? ");
        if (StringUtils.isNotEmpty(schema)) {
            query.append("AND OWNER = ?");
        } else {
            query.append("AND OWNER = USER");
        }
        PreparedStatement pstmt = conn.prepareStatement(query.toString());
        pstmt.setString(1, tableName.toUpperCase());
        if (StringUtils.isNotEmpty(schema)) {
            pstmt.setString(2, schema.toUpperCase());
        }
        if ((rs = pstmt.executeQuery()).next()) {
            comment = rs.getString(1);
        }
        rs.close();
        pstmt.close();
        return StringUtils.isEmpty(comment) ? tableName : comment;
    }

    protected String getColumnComment(String tableName, String columnName, Connection conn, String catalog, String schema) throws SQLException {
        ResultSet rs;
        String comment = columnName;
        StringBuffer query = new StringBuffer();
        query.append("SELECT COMMENTS FROM ALL_COL_COMMENTS WHERE TABLE_NAME = ? AND COLUMN_NAME = ? ");
        if (StringUtils.isNotEmpty(schema)) {
            query.append("AND OWNER = ?");
        } else {
            query.append("AND OWNER = USER");
        }
        PreparedStatement pstmt = conn.prepareStatement(query.toString());
        pstmt.setString(1, tableName.toUpperCase());
        pstmt.setString(2, columnName.toUpperCase());
        if (StringUtils.isNotEmpty(schema)) {
            pstmt.setString(3, schema.toUpperCase());
        }
        if ((rs = pstmt.executeQuery()).next()) {
            comment = rs.getString(1);
        }
        rs.close();
        pstmt.close();
        return StringUtils.isEmpty(comment) ? columnName : comment;
    }
}

