/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import net.java.amateras.db.Messages;
import net.java.amateras.db.dialect.AbstractDialect;
import net.java.amateras.db.dialect.ColumnType;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class PostgreSQLDialect
extends AbstractDialect {
    private static final IColumnType[] COLUMN_TYPES = new IColumnType[]{new ColumnType("BIGINT", Messages.getResourceString("type.integer"), false, -5), new ColumnType("BIT", Messages.getResourceString("type.bit"), true, -7), new ColumnType("VARBIT", Messages.getResourceString("type.bit"), true, -7), new ColumnType("BOOLEAN", Messages.getResourceString("type.boolean"), false, 16), new ColumnType("BYTEA", Messages.getResourceString("type.binary"), false, -2), new ColumnType("VARCHAR", Messages.getResourceString("type.string"), true, 12), new ColumnType("CHARACTER", Messages.getResourceString("type.char"), true, 1), new ColumnType("DATE", Messages.getResourceString("type.date"), false, 91), new ColumnType("INTEGER", Messages.getResourceString("type.integer"), false, 4), new ColumnType("NUMERIC", Messages.getResourceString("type.numeric"), true, 2), new ColumnType("REAL", Messages.getResourceString("type.real"), false, 7), new ColumnType("SMALLINT", Messages.getResourceString("type.integer"), false, 5), new ColumnType("TEXT", Messages.getResourceString("type.string"), false, 12), new ColumnType("TIME", Messages.getResourceString("type.time"), false, 92), new ColumnType("TIMESTAMP", Messages.getResourceString("type.datetime"), false, 93), new ColumnType("SERIAL", Messages.getResourceString("type.serial"), false, 4), new ColumnType("BIGSERIAL", Messages.getResourceString("type.serial"), false, -5), new ColumnType("XML", Messages.getResourceString("type.xml"), false, 2009), new ColumnType("INTERVAL", Messages.getResourceString("type.interval"), false, 1111), new ColumnType("INET", Messages.getResourceString("type.networkaddress"), false, 1111), new ColumnType("CIDR", Messages.getResourceString("type.networkaddress"), false, 1111), new ColumnType("MACADDR", Messages.getResourceString("type.macaddress"), false, 1111)};

    public PostgreSQLDialect() {
        super(COLUMN_TYPES);
    }

    @Override
    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions, boolean comment) {
        StringBuffer sb = new StringBuffer();
        sb.append(columnModel.getColumnName());
        if (columnModel.isAutoIncrement()) {
            if (columnModel.getColumnType().getName().equals("BIGINT")) {
                sb.append(" BIGSERIAL");
            } else {
                sb.append(" SERIAL");
            }
        } else {
            sb.append(" ").append(columnModel.getColumnType().getName());
            if (columnModel.getColumnType().supportSize() && columnModel.getSize().length() > 0) {
                sb.append("(").append(columnModel.getSize()).append(")");
            }
            if (columnModel.isNotNull()) {
                sb.append(" NOT NULL");
            }
        }
        if (columnModel.getDefaultValue().length() != 0) {
            sb.append(" DEFAULT ").append(columnModel.getDefaultValue());
        }
        if (columnModel.isPrimaryKey() && !alterTable && tableModel.getPrimaryKeyColumns().length == 1) {
            sb.append(" PRIMARY KEY");
        }
        return sb.toString();
    }

    @Override
    public String getColumnMetadataSQL(String tableName) {
        return String.valueOf(super.getColumnMetadataSQL(tableName)) + "  LIMIT 1";
    }
}

