/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class TableDependencyCalculator {
    public static List<TableModel> getSortedTable(RootModel root) {
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        for (TableModel table : root.getTables()) {
            TableDependencyCalculator.addTableModel(result, table, null);
        }
        return result;
    }

    private static void addTableModel(List<TableModel> result, TableModel table, Set<TableModel> dependentModels) {
        if (dependentModels == null) {
            dependentModels = new HashSet<TableModel>();
        }
        if (result.contains(table)) {
            return;
        }
        HashSet<TableModel> innerDependentModels = new HashSet<TableModel>(dependentModels);
        dependentModels.add(table);
        for (AbstractDBConnectionModel conn : table.getModelSourceConnections()) {
            ForeignKeyModel fk;
            TableModel target;
            if (!(conn instanceof ForeignKeyModel) || dependentModels.contains(target = (TableModel)(fk = (ForeignKeyModel)conn).getTarget())) continue;
            TableDependencyCalculator.addTableModel(result, target, innerDependentModels);
        }
        result.add(table);
    }
}

