/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.preference;

import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.NameConverter;
import net.java.amateras.db.util.TableViewerSupport;
import net.java.amateras.db.util.UIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DictionaryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer viewer;
    private List<NameConverter.DictionaryEntry> models;

    public DictionaryPreferencePage() {
        super("DictionaryPreferencePage");
    }

    public void init(IWorkbench workbench) {
    }

    public Point computeSize() {
        Point point = super.computeSize();
        return new Point(point.x, 0);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.models = NameConverter.loadFromPreferenceStore(DBPlugin.getDefault().getPreferenceStore());
        TableViewerSupport<NameConverter.DictionaryEntry> support = new TableViewerSupport<NameConverter.DictionaryEntry>(this.models, composite){

            @Override
            protected NameConverter.DictionaryEntry doAdd() {
                EntryEditDialog dialog = new EntryEditDialog(DictionaryPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getEntry();
                }
                return null;
            }

            @Override
            protected void doEdit(NameConverter.DictionaryEntry entry) {
                EntryEditDialog dialog = new EntryEditDialog(DictionaryPreferencePage.this.getShell(), entry);
                if (dialog.open() == 0) {
                    NameConverter.DictionaryEntry newEntry = dialog.getEntry();
                    entry.logicalName = newEntry.logicalName;
                    entry.physicalName = newEntry.physicalName;
                    entry.partialMatch = newEntry.partialMatch;
                }
            }
        };
        support.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer = support.getTableViewer();
        return composite;
    }

    public boolean performCancel() {
        this.models.clear();
        this.models.addAll(NameConverter.loadDefaultDictionary());
        this.viewer.refresh();
        return true;
    }

    public boolean performOk() {
        NameConverter.saveToPreferenceStore(DBPlugin.getDefault().getPreferenceStore(), this.models);
        return true;
    }

    protected void performDefaults() {
        List<NameConverter.DictionaryEntry> defaultEntries = NameConverter.loadDefaultDictionary();
        this.models.clear();
        this.models.addAll(defaultEntries);
        this.viewer.refresh();
    }

    private class EntryEditDialog
    extends Dialog {
        private Text logicalName;
        private Text physicalName;
        private Button partMatch;
        private NameConverter.DictionaryEntry element;

        public EntryEditDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public EntryEditDialog(Shell parentShell, NameConverter.DictionaryEntry element) {
            super(parentShell);
            this.element = element;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(DBPlugin.getResourceString("dialog.dictionary.title"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            UIUtils.createLabel(composite, "label.physicalName");
            this.physicalName = new Text(composite, 2048);
            this.physicalName.setLayoutData((Object)new GridData(768));
            if (this.element != null) {
                this.physicalName.setText(this.element.physicalName);
            }
            UIUtils.createLabel(composite, "label.logicalName");
            this.logicalName = new Text(composite, 2048);
            if (this.element != null) {
                this.logicalName.setText(this.element.logicalName);
            }
            this.logicalName.setLayoutData((Object)new GridData(768));
            UIUtils.createLabel(composite, "label.partialMatch");
            this.partMatch = new Button(composite, 32);
            if (this.element != null) {
                this.partMatch.setSelection(this.element.partialMatch);
            }
            return composite;
        }

        protected void okPressed() {
            if (this.physicalName.getText().length() == 0) {
                UIUtils.openAlertDialog(DBPlugin.getDefault().createMessage(DBPlugin.getResourceString("error.required"), new String[]{DBPlugin.getResourceString("label.physicalName")}));
                return;
            }
            if (this.logicalName.getText().length() == 0) {
                UIUtils.openAlertDialog(DBPlugin.getDefault().createMessage(DBPlugin.getResourceString("error.required"), new String[]{DBPlugin.getResourceString("label.logicalName")}));
                return;
            }
            this.element = new NameConverter.DictionaryEntry(this.physicalName.getText(), this.logicalName.getText(), this.partMatch.getSelection());
            super.okPressed();
        }

        public NameConverter.DictionaryEntry getEntry() {
            return this.element;
        }
    }
}

