/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.sqleditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class EditorColorProvider {
    private Map<RGB, Color> colorTable = new HashMap<RGB, Color>(10);
    private Map<String, IToken> tokenTable = new HashMap<String, IToken>(10);
    IPreferenceStore store;

    public EditorColorProvider(IPreferenceStore store) {
        this.store = store;
    }

    public IToken getToken(String prefKey) {
        Token token = (Token)this.tokenTable.get(prefKey);
        if (token == null) {
            String colorName = this.store.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token = new Token((Object)new TextAttribute(this.getColor(rgb)));
            this.tokenTable.put(prefKey, (IToken)token);
        }
        return token;
    }

    public void dispose() {
        Iterator<Color> e = this.colorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(String prefKey) {
        String colorName = this.store.getString(prefKey);
        RGB rgb = StringConverter.asRGB((String)colorName);
        return this.getColor(rgb);
    }

    private Color getColor(RGB rgb) {
        Color color = this.colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colorTable.put(rgb, color);
        }
        return color;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        Token token = (Token)this.tokenTable.get(event.getProperty());
        return token != null;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        Token token = (Token)this.tokenTable.get(prefKey);
        if (token != null) {
            String colorName = this.store.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token.setData((Object)new TextAttribute(this.getColor(rgb)));
        }
    }
}

