/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class AbstractDialogPropertyDescriptor
extends PropertyDescriptor {
    public AbstractDialogPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ValueCellEditor editor = new ValueCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    protected abstract Object openDialogBox(Object var1, Control var2);

    protected abstract String getDisplayText(Object var1);

    protected class ValueCellEditor
    extends CellEditor {
        private Text text;
        private Composite editor;
        private Button button;
        private Object value;

        public ValueCellEditor(Composite parent) {
            super(parent, 0);
            this.value = null;
        }

        protected Control createControl(Composite parent) {
            Font font = parent.getFont();
            Color bg = parent.getBackground();
            this.editor = new Composite(parent, this.getStyle());
            this.editor.setFont(font);
            this.editor.setBackground(bg);
            this.editor.setLayout((Layout)new DialogCellLayout());
            this.text = new Text(this.editor, 8);
            this.text.setFont(parent.getFont());
            this.text.setBackground(parent.getBackground());
            this.button = new Button(this.editor, 1024);
            this.button.setText("...");
            this.button.setFont(font);
            this.button.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ValueCellEditor.this.fireCancelEditor();
                    }
                }
            });
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object newValue = ValueCellEditor.this.openDialogBox((Control)ValueCellEditor.this.editor);
                    if (newValue != null) {
                        ValueCellEditor.this.updateValue(newValue);
                    }
                }
            });
            this.setValueValid(true);
            this.updateContents(this.value);
            return this.editor;
        }

        private void updateValue(Object newValue) {
            if (newValue != null) {
                boolean newValidState = this.isCorrect(newValue);
                if (newValidState) {
                    this.markDirty();
                    this.doSetValue(newValue);
                } else {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                }
                this.fireApplyEditorValue();
            }
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
            this.button.setFocus();
        }

        protected void doSetValue(Object value) {
            this.value = value;
            this.updateContents(value);
        }

        public boolean isCopyEnabled() {
            return false;
        }

        public boolean isCutEnabled() {
            return false;
        }

        public boolean isDeleteEnabled() {
            return false;
        }

        public boolean isPasteEnabled() {
            return false;
        }

        public boolean isSelectAllEnabled() {
            return false;
        }

        public void performCopy() {
        }

        public void performCut() {
        }

        public void performDelete() {
        }

        public void performPaste() {
        }

        public void performSelectAll() {
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            return AbstractDialogPropertyDescriptor.this.openDialogBox(this.value, cellEditorWindow);
        }

        protected void updateContents(Object value) {
            if (this.text == null) {
                return;
            }
            String text = "";
            if (value != null) {
                text = AbstractDialogPropertyDescriptor.this.getDisplayText(value);
            }
            this.text.setText(text);
        }

        private class DialogCellLayout
        extends Layout {
            private DialogCellLayout() {
            }

            public void layout(Composite editor, boolean force) {
                Rectangle bounds = editor.getClientArea();
                Point size = ValueCellEditor.this.button.computeSize(-1, -1, force);
                if (ValueCellEditor.this.text != null) {
                    ValueCellEditor.this.text.setBounds(0, 0, bounds.width - size.x, bounds.height);
                }
                ValueCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
            }

            public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point contentsSize = ValueCellEditor.this.text.computeSize(-1, -1, force);
                Point buttonSize = ValueCellEditor.this.button.computeSize(-1, -1, force);
                Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                return result;
            }
        }
    }
}

