/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DatabaseInfo {
    private String uri = "";
    private String user = "";
    private String password = "";
    private String catalog = "";
    private String schema = "";
    private Driver driver = null;
    private boolean enableView = false;
    private String productName = null;
    private boolean autoConvert = false;
    public final String POSTGRESQL = "PostgreSQL";
    public final String MYSQL = "MySQL";
    public final String HSQLDB = "HSQL Database Engine";
    public final String DERBY = "Apache Derby";
    public final String SYBASE = "Adaptive Server Enterprise";

    public DatabaseInfo(Class<?> driverClass) throws InstantiationException, IllegalAccessException {
        this.driver = (Driver)driverClass.newInstance();
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setEnableView(boolean flag) {
        this.enableView = flag;
    }

    public boolean isEnableView() {
        return this.enableView;
    }

    public boolean isAutoConvert() {
        return this.autoConvert;
    }

    public void setAutoConvert(boolean autoConvert) {
        this.autoConvert = autoConvert;
    }

    public Connection connect() throws SQLException {
        Properties p = new Properties();
        if (this.isSybase()) {
            p.setProperty("JCONNECT_VERSION", "3");
            p.setProperty("charSet", "eucksc");
        }
        p.setProperty("user", this.user);
        p.setProperty("password", this.password);
        return this.driver.connect(this.uri, p);
    }

    public List<String> loadTables() throws SQLException {
        ArrayList<String> list;
        block12: {
            list = new ArrayList<String>();
            try (Connection con = null;){
                String[] stringArray;
                con = this.connect();
                DatabaseMetaData meta = con.getMetaData();
                this.productName = meta.getDatabaseProductName();
                if (this.isMSSQL() && this.catalog.length() == 0) {
                    this.catalog = "%";
                }
                this.catalog = this.catalog.length() == 0 ? null : this.catalog;
                String string = this.schema = this.schema.length() == 0 ? null : this.schema;
                if (this.isOracle()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "TABLE";
                    stringArray2[1] = "VIEW";
                    stringArray = stringArray2;
                    stringArray2[2] = "SYNONYM";
                } else {
                    stringArray = null;
                }
                ResultSet tables = meta.getTables(this.catalog, this.schema, "%", stringArray);
                while (tables.next()) {
                    String t = tables.getString("TABLE_TYPE");
                    if (!"TABLE".equals(t) && (!"VIEW".equals(t) || !this.enableView) && (!this.isOracle() || !"SYNONYM".equals(t))) continue;
                    list.add(tables.getString("table_name"));
                }
                tables.close();
                if (!this.driver.getClass().getName().equals("org.hsqldb.jdbcDriver") || this.uri.indexOf("jdbc:hsqldb:hsql://") == 0) break block12;
                try (Statement stmt = null;){
                    stmt = con.createStatement();
                    stmt.executeUpdate("SHUTDOWN;");
                }
            }
        }
        return list;
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean isPostgreSQL() {
        return "PostgreSQL".equals(this.productName);
    }

    public boolean isMySQL() {
        return "MySQL".equals(this.productName);
    }

    public boolean isHSQLDB() {
        return "HSQL Database Engine".equals(this.productName);
    }

    public boolean isDerby() {
        return "Apache Derby".equals(this.productName);
    }

    public boolean isMSSQL() {
        return this.productName.toLowerCase().indexOf("microsoft") != -1;
    }

    public boolean isSybase() {
        return "Adaptive Server Enterprise".equals(this.productName);
    }

    public boolean isOracle() {
        return this.productName.toLowerCase().indexOf("oracl") != -1;
    }
}

