/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader(URL url) {
        super(new URL[]{url});
    }

    public JarClassLoader(URL[] urls) {
        super(urls);
    }

    public void getJDBCDriverClass(List<Class<?>> list, Class<?> cls, Class<?> org) {
        Class<?>[] interfaces = cls.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            interfaces[i].getInterfaces();
            if (interfaces[i].equals(Driver.class)) {
                list.add(org);
            }
            ++i;
        }
        Class<?> s = cls.getSuperclass();
        if (s != null) {
            this.getJDBCDriverClass(list, s, org);
        }
    }

    public List<Class<?>> getJDBCDriverClass(String jarName) throws IOException, ClassNotFoundException {
        if (jarName.equals("")) {
            return Collections.emptyList();
        }
        JarFile jarFile = new JarFile(jarName);
        Enumeration<JarEntry> e = jarFile.entries();
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (name.lastIndexOf(".class") == -1) continue;
            String ccls = name.replaceFirst(".class", "").replaceAll("/", ".");
            try {
                Class<?> cls = this.loadClass(ccls, true);
                this.getJDBCDriverClass(list, cls, cls);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return list;
    }
}

