/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.util.List;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class ModelUtils {
    public static void importOrReplaceTable(RootModel rootModel, TableModel oldTable, TableModel newTable) {
        ModelUtils.stripConnections(newTable.getModelSourceConnections());
        ModelUtils.stripConnections(newTable.getModelTargetConnections());
        if (oldTable != null) {
            rootModel.removeChild(oldTable);
            for (AbstractDBConnectionModel conn : oldTable.getModelTargetConnections()) {
                if (conn instanceof ForeignKeyModel) {
                    ForeignKeyMapping[] mappings;
                    ForeignKeyModel fk = (ForeignKeyModel)conn;
                    ForeignKeyMapping[] foreignKeyMappingArray = mappings = fk.getMapping();
                    int n = mappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ForeignKeyMapping mapping = foreignKeyMappingArray[n2];
                        ColumnModel oldColumn = mapping.getTarget();
                        ColumnModel newColumn = newTable.getColumn(oldColumn.getColumnName());
                        mapping.setTarget(newColumn);
                        ++n2;
                    }
                    fk.setMapping(mappings);
                }
                conn.setTarget(newTable);
                newTable.addTargetConnection(conn);
            }
            newTable.setConstraint(oldTable.getConstraint());
        }
        newTable.setLinkedPath(oldTable.getLinkedPath());
        rootModel.addChild(newTable);
    }

    public static void stripConnections(List<AbstractDBConnectionModel> conns) {
        AbstractDBConnectionModel[] abstractDBConnectionModelArray = conns.toArray(new AbstractDBConnectionModel[conns.size()]);
        int n = abstractDBConnectionModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDBConnectionModel conn = abstractDBConnectionModelArray[n2];
            conn.getSource().removeSourceConnection(conn);
            conn.getTarget().removeTargetConnection(conn);
            ++n2;
        }
    }
}

