/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.IOUtils;
import net.java.amateras.db.util.TableViewerSupport;
import org.eclipse.jface.preference.IPreferenceStore;

public class NameConverter {
    public static List<DictionaryEntry> loadDefaultDictionary() {
        String[] lines;
        ArrayList<DictionaryEntry> entries = new ArrayList<DictionaryEntry>();
        InputStream in = NameConverter.class.getResourceAsStream("dictionary.txt");
        String str = IOUtils.loadStream(in, "UTF-8");
        str = str.replaceAll("\r\n", "\n");
        str = str.replaceAll("\r", "\n");
        String[] stringArray = lines = str.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String key = line.substring(0, line.indexOf(61));
            String value = line.substring(line.indexOf(61) + 1);
            boolean partMatch = false;
            if (key.startsWith("_")) {
                partMatch = true;
                key = key.substring(1);
            }
            entries.add(new DictionaryEntry(key, value, partMatch));
            ++n2;
        }
        return entries;
    }

    public static void saveToPreferenceStore(IPreferenceStore store, List<DictionaryEntry> entries) {
        StringBuilder sb = new StringBuilder();
        for (DictionaryEntry entry : entries) {
            sb.append(entry.toString()).append("\n");
        }
        store.setValue("pref_dictionary", sb.toString());
    }

    public static List<DictionaryEntry> loadFromPreferenceStore(IPreferenceStore store) {
        ArrayList<DictionaryEntry> entries = new ArrayList<DictionaryEntry>();
        String value = store.getString("pref_dictionary");
        String[] stringArray = value.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] dim = line.split(",");
            DictionaryEntry entry = new DictionaryEntry(dim[0], dim[1], Boolean.parseBoolean(dim[2]));
            entries.add(entry);
            ++n2;
        }
        return entries;
    }

    public static String logical2physical(String logical) {
        logical = logical.toUpperCase();
        for (DictionaryEntry entry : NameConverter.loadFromPreferenceStore(DBPlugin.getDefault().getPreferenceStore())) {
            logical = logical.replace(entry.logicalName, "_" + entry.physicalName + "_");
        }
        logical = logical.replaceAll("_+", "_");
        logical = logical.replaceAll("^_|_$", "");
        return logical;
    }

    public static String physical2logical(String physical) {
        physical = physical.toUpperCase();
        ArrayList<DictionaryEntry> entries = new ArrayList<DictionaryEntry>(NameConverter.loadFromPreferenceStore(DBPlugin.getDefault().getPreferenceStore()));
        Collections.sort(entries, new Comparator<DictionaryEntry>(){

            @Override
            public int compare(DictionaryEntry o1, DictionaryEntry o2) {
                return o1.physicalName.length() < o1.physicalName.length() ? 1 : (o1.physicalName.length() > o2.physicalName.length() ? -1 : 0);
            }
        });
        for (DictionaryEntry entry : entries) {
            String physicalName = entry.physicalName;
            if (entry.partialMatch) {
                physicalName = "_" + physicalName;
            }
            physical = physical.replace(physicalName, entry.logicalName);
        }
        physical = physical.replace("_", "");
        return physical;
    }

    public static class DictionaryEntry {
        @TableViewerSupport.ColumnInfo(index=0, width=150, label="label.physicalName")
        public String physicalName;
        @TableViewerSupport.ColumnInfo(index=1, width=150, label="label.logicalName")
        public String logicalName;
        @TableViewerSupport.ColumnInfo(index=2, width=100, label="label.partialMatch")
        public boolean partialMatch;

        public DictionaryEntry(String physicalName, String logicalName, boolean partialMatch) {
            this.physicalName = physicalName;
            this.logicalName = logicalName;
            this.partialMatch = partialMatch;
        }

        public String toString() {
            return String.valueOf(this.physicalName) + "," + this.logicalName + "," + this.partialMatch;
        }
    }
}

