/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.GenericsUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableViewerSupport<T> {
    private Composite control;
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private List<T> model;

    public TableViewerSupport(List<T> model, Composite parent) {
        this.model = model;
        this.initComponents(parent);
    }

    public Control getControl() {
        return this.control;
    }

    private void initComponents(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(this.control, 68354);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path;
                TableItem[] items = TableViewerSupport.this.viewer.getTable().getSelection();
                boolean enable = false;
                if (items.length > 0 && !(path = items[0].getText(1)).equals("[Default]")) {
                    enable = true;
                }
                TableViewerSupport.this.buttonEdit.setEnabled(enable);
                TableViewerSupport.this.buttonRemove.setEnabled(enable);
            }
        });
        this.initTableViewer(this.viewer);
        Composite buttons = new Composite(this.control, 0);
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText(DBPlugin.getResourceString("button.add"));
        this.buttonAdd.setLayoutData((Object)TableViewerSupport.createButtonGridData());
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object obj = TableViewerSupport.this.doAdd();
                if (obj != null) {
                    TableViewerSupport.this.model.add(obj);
                    TableViewerSupport.this.viewer.refresh();
                }
            }
        });
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText(DBPlugin.getResourceString("button.edit"));
        this.buttonEdit.setLayoutData((Object)TableViewerSupport.createButtonGridData());
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)TableViewerSupport.this.viewer.getSelection();
                Object obj = sel.getFirstElement();
                TableViewerSupport.this.doEdit(obj);
                TableViewerSupport.this.viewer.refresh();
            }
        });
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText(DBPlugin.getResourceString("button.delete"));
        this.buttonRemove.setLayoutData((Object)TableViewerSupport.createButtonGridData());
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)TableViewerSupport.this.viewer.getSelection();
                List list = sel.toList();
                TableViewerSupport.this.doRemove(list);
                TableViewerSupport.this.viewer.refresh();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)TableViewerSupport.this.viewer.getSelection();
                if (sel == null || sel.getFirstElement() == null) {
                    TableViewerSupport.this.buttonEdit.setEnabled(false);
                    TableViewerSupport.this.buttonRemove.setEnabled(false);
                } else {
                    TableViewerSupport.this.buttonEdit.setEnabled(true);
                    TableViewerSupport.this.buttonRemove.setEnabled(true);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.viewer.setInput(this.model);
    }

    protected void initTableViewer(TableViewer viewer) {
        Type[] types = GenericsUtils.getGenericType(this, TableViewerSupport.class);
        Table table = viewer.getTable();
        for (ColumnInfo column : TableViewerSupport.getColumns((Class)types[0])) {
            TableColumn col = new TableColumn(table, 0);
            col.setText(DBPlugin.getResourceString(column.label()));
            col.setWidth(column.width());
        }
    }

    protected abstract T doAdd();

    protected abstract void doEdit(T var1);

    protected void doRemove(List<T> objList) {
        this.model.removeAll(objList);
    }

    protected ITableLabelProvider createLabelProvider() {
        return new DefaultTableLabelProvider();
    }

    public List<T> getModel() {
        return this.model;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    private static GridData createButtonGridData() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        return gd;
    }

    public static List<ColumnInfo> getColumns(Class<?> clazz) {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            ColumnInfo annotation = field.getAnnotation(ColumnInfo.class);
            if (annotation != null) {
                columns.add(annotation);
            }
            ++n2;
        }
        Collections.sort(columns, new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                return o1.index() > o2.index() ? 1 : (o1.index() < o2.index() ? -1 : 0);
            }
        });
        return columns;
    }

    public static String getColumnValue(Object element, int columnIndex) {
        Field[] fieldArray = element.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            Field field = fieldArray[n2];
            ColumnInfo annotation = field.getAnnotation(ColumnInfo.class);
            if (annotation != null && (index = annotation.index()) == columnIndex) {
                Object value;
                block5: {
                    try {
                        value = field.get(element);
                        if (value != null) break block5;
                        return "";
                    }
                    catch (Exception exception) {}
                }
                return value.toString();
            }
            ++n2;
        }
        return "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @Documented
    public static @interface ColumnInfo {
        public int index();

        public String label();

        public int width();
    }

    public static class DefaultTableLabelProvider
    extends TableLabelProviderAdapter {
        @Override
        public String getColumnText(Object element, int columnIndex) {
            return TableViewerSupport.getColumnValue(element, columnIndex);
        }
    }

    public static class ListContentProvider
    implements IStructuredContentProvider {
        List fContents;

        public Object[] getElements(Object input) {
            if (this.fContents != null && this.fContents == input) {
                return this.fContents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fContents = newInput instanceof List ? (List)newInput : null;
        }

        public void dispose() {
        }

        public boolean isDeleted(Object o) {
            return this.fContents != null && !this.fContents.contains(o);
        }
    }

    public static abstract class TableLabelProviderAdapter
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

