/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.util;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.editor.VisualDBEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIUtils {
    public static GridData createGridData(int colspan) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        return gd;
    }

    public static GridData createGridData(int colspan, int option) {
        GridData gd = new GridData(option);
        gd.horizontalSpan = colspan;
        return gd;
    }

    public static GridData createGridDataWithWidth(int width) {
        GridData gd = new GridData();
        gd.widthHint = width;
        return gd;
    }

    public static GridData createGridDataWithColspan(int colspan, int height) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        gd.heightHint = height;
        return gd;
    }

    public static GridData createGridDataWithRowspan(int rowspan, int width) {
        GridData gd = new GridData(1040);
        gd.verticalSpan = rowspan;
        gd.widthHint = width;
        return gd;
    }

    public static void createColumn(Table table, String key, int width) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(DBPlugin.getResourceString(key));
        column.setWidth(width);
    }

    public static Label createLabel(Composite parent, String key) {
        Label label = new Label(parent, 0);
        label.setText(DBPlugin.getResourceString(key));
        return label;
    }

    public static void openAlertDialog(String messageKey) {
        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        box.setMessage(DBPlugin.getResourceString(messageKey));
        box.setText(DBPlugin.getResourceString("dialog.alert.title"));
        box.open();
    }

    public static VisualDBEditor getActiveEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart instanceof VisualDBEditor) {
            return (VisualDBEditor)editorPart;
        }
        return null;
    }
}

