/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class DiagramErrors {
    private List<DiagramError> errors = new ArrayList<DiagramError>();
    public static final String ERROR_PREFIX = "[ERROR]";
    public static final String WARNING_PREFIX = "[WARN]";

    private static String createColumnMessage(TableModel table, ColumnModel column, String message) {
        return "[" + table.getTableName() + "." + column.getColumnName() + "]" + message;
    }

    private static String createColumnMessage(ColumnModel column, String message) {
        return "[" + column.getColumnName() + "]" + message;
    }

    private static String createIndexMessage(TableModel table, IndexModel index, String message) {
        return "[" + table.getTableName() + "." + index.getIndexName() + "]" + message;
    }

    private static String createIndexMessage(IndexModel index, String message) {
        return "[" + index.getIndexName() + "]" + message;
    }

    private static String createTableMessage(TableModel table, String message) {
        return "[" + table.getTableName() + "]" + message;
    }

    public void addError(String level, TableModel table, String message) {
        if (level.equals("ERROR")) {
            this.errors.add(new DiagramError(table, DiagramErrors.createTableMessage(table, message), level));
            this.addErrorMessageToModel(table, ERROR_PREFIX + message);
        } else if (level.equals("WARNING")) {
            this.errors.add(new DiagramError(table, DiagramErrors.createTableMessage(table, message), level));
            this.addErrorMessageToModel(table, WARNING_PREFIX + message);
        }
    }

    public void addError(String level, TableModel table, ColumnModel column, String message) {
        if (level.equals("ERROR")) {
            this.errors.add(new DiagramError(table, DiagramErrors.createColumnMessage(table, column, message), level));
            this.addErrorMessageToModel(table, ERROR_PREFIX + DiagramErrors.createColumnMessage(column, message));
        } else if (level.equals("WARNING")) {
            this.errors.add(new DiagramError(table, DiagramErrors.createColumnMessage(table, column, message), level));
            this.addErrorMessageToModel(table, WARNING_PREFIX + DiagramErrors.createColumnMessage(column, message));
        }
    }

    public void addError(String level, TableModel table, IndexModel index, String message) {
        if (level.equals("ERROR")) {
            this.errors.add(new DiagramError(table, DiagramErrors.createIndexMessage(table, index, message), level));
            this.addErrorMessageToModel(table, ERROR_PREFIX + DiagramErrors.createIndexMessage(index, message));
        } else if (level.equals("WARNING")) {
            this.errors.add(new DiagramError(table, DiagramErrors.createIndexMessage(table, index, message), level));
            this.addErrorMessageToModel(table, WARNING_PREFIX + DiagramErrors.createIndexMessage(index, message));
        }
    }

    private void addErrorMessageToModel(TableModel table, String message) {
        String error = table.getError();
        if (error.length() > 0) {
            error = String.valueOf(error) + "\n";
        }
        error = String.valueOf(error) + message;
        table.setError(error);
    }

    public List<DiagramError> getErrors() {
        return this.errors;
    }

    public static class DiagramError {
        private Object target;
        private String message;
        private String level;

        private DiagramError(Object target, String message, String level) {
            this.target = target;
            this.message = message;
            this.level = level;
        }

        public Object getTarget() {
            return this.target;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLevel() {
            return this.level;
        }

        public void addMarker(IFile file) {
            if (this.level == "ERROR") {
                DiagramError.addMarker((IResource)file, 2, this.message);
            } else {
                DiagramError.addMarker((IResource)file, 1, this.message);
            }
        }

        private static void addMarker(IResource resource, int type, String message) {
            try {
                IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("severity", new Integer(type));
                map.put("message", message);
                marker.setAttributes(map);
            }
            catch (CoreException ex) {
                DBPlugin.logException((Exception)((Object)ex));
            }
        }
    }
}

