/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ChangeDBTypeAction
extends Action {
    private GraphicalViewer viewer;

    public ChangeDBTypeAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.changeDatabaseType"));
        this.viewer = viewer;
    }

    public void run() {
        RootModel root = (RootModel)this.viewer.getContents().getModel();
        WizardDialog dialog = new WizardDialog(this.viewer.getControl().getShell(), (IWizard)new ChangeDBTypeWizard(root));
        dialog.open();
    }

    private static IColumnType getColumnType(IDialect dialect, TableModel table, ColumnModel column) {
        IColumnType type = dialect.getColumnType(column.getColumnType().getType());
        if (type == null) {
            type = dialect.getDefaultColumnType();
        }
        return type;
    }

    private class ChangeDBTypeWizard
    extends Wizard {
        private RootModel root;
        private ChangeDBTypeWizardPage page;

        public ChangeDBTypeWizard(RootModel rootModel) {
            this.setWindowTitle(DBPlugin.getResourceString("wizard.changedb.title"));
            this.root = rootModel;
        }

        public void addPages() {
            this.page = new ChangeDBTypeWizardPage(this.root.getDialectName());
            this.addPage((IWizardPage)this.page);
        }

        public boolean performFinish() {
            String result = this.page.dbType.getText();
            if (!result.equals(this.root.getDialectName())) {
                IDialect dialect = DialectProvider.getDialect(result);
                for (AbstractDBEntityModel entity : this.root.getChildren()) {
                    if (!(entity instanceof TableModel)) continue;
                    TableModel table = (TableModel)entity;
                    ColumnModel[] columnModelArray = table.getColumns();
                    int n = columnModelArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ColumnModel column = columnModelArray[n2];
                        IColumnType type = ChangeDBTypeAction.getColumnType(dialect, table, column);
                        column.setColumnType(type);
                        ++n2;
                    }
                    table.setColumns(table.getColumns());
                }
                this.root.setDialectName(result);
            }
            return true;
        }
    }

    private class ChangeDBTypeWizardPage
    extends WizardPage {
        private Combo dbType;
        private String dbName;

        public ChangeDBTypeWizardPage(String dbName) {
            super("ChangeDBTypeWizardPage");
            this.setTitle(DBPlugin.getResourceString("wizard.changedb.title"));
            this.setDescription(DBPlugin.getResourceString("wizard.changedb.description"));
            this.dbName = dbName;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(1808));
            UIUtils.createLabel(composite, DBPlugin.getResourceString("wizard.changedb.databaseType"));
            this.dbType = new Combo(composite, 8);
            String[] stringArray = DialectProvider.getDialectNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dbName = stringArray[n2];
                this.dbType.add(dbName);
                ++n2;
            }
            this.dbType.setText(this.dbName);
            this.setControl((Control)composite);
        }
    }
}

