/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.action.PasteAction;
import net.java.amateras.db.visual.editor.VisualDBEditor;
import net.java.amateras.db.visual.model.ICloneableModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends SelectionAction {
    private PasteAction pasteAction;

    public CopyAction(VisualDBEditor editor, PasteAction pasteAction) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.COPY.getId());
        this.setText(DBPlugin.getResourceString("action.copy"));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.pasteAction = pasteAction;
    }

    public void run() {
        List selection = this.getSelectedObjects();
        ArrayList<ICloneableModel> copied = new ArrayList<ICloneableModel>();
        int i = 0;
        while (i < selection.size()) {
            EditPart editPart = (EditPart)selection.get(i);
            ICloneableModel cloneable = (ICloneableModel)editPart.getModel();
            copied.add(cloneable.clone());
            ++i;
        }
        Clipboard.getDefault().setContents(copied);
        this.pasteAction.update();
    }

    protected boolean calculateEnabled() {
        List selected = this.getSelectedObjects();
        if (selected.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < selected.size()) {
            if (!(selected.get(i) instanceof EditPart)) {
                return false;
            }
            EditPart editPart = (EditPart)selected.get(i);
            if (ICloneableModel.class.isAssignableFrom(editPart.getModel().getClass())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

