/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class DeleteMarkerAction
extends Action {
    private GraphicalViewer viewer;

    public DeleteMarkerAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.validation.deleteMarkers"));
        this.viewer = viewer;
    }

    public void run() {
        CommandStack stack = this.viewer.getEditDomain().getCommandStack();
        stack.execute(new Command("Delete markers"){

            public void execute() {
                RootModel model = (RootModel)DeleteMarkerAction.this.viewer.getRootEditPart().getContents().getModel();
                for (AbstractDBEntityModel entity : model.getChildren()) {
                    if (!(entity instanceof TableModel)) continue;
                    ((TableModel)entity).setError("");
                }
            }

            public boolean canUndo() {
                return false;
            }
        });
        IEditorInput input = UIUtils.getActiveEditor().getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            }
            catch (CoreException ex) {
                DBPlugin.logException((Exception)((Object)ex));
            }
        }
    }
}

