/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.DommainModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DommainEditDialog
extends Dialog {
    private TableViewer viewer;
    private RootModel rootModel;
    private IDialect dialect;
    private List<DommainModel> result = new ArrayList<DommainModel>();
    private DommainModel editingModel = null;
    private Text dommainName;
    private Combo columnType;
    private Text columnSize;
    private Button removeButton;
    private Button addButton;

    protected DommainEditDialog(Shell parentShell, RootModel rootModel, DommainModel editDommain) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        for (DommainModel model : rootModel.getDommains()) {
            DommainModel clonedModel = model.clone();
            if (editDommain != null && model == editDommain) {
                this.editingModel = clonedModel;
            }
            this.result.add(clonedModel);
        }
        this.rootModel = rootModel;
        this.dialect = DialectProvider.getDialect(rootModel.getDialectName());
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        point.y = 350;
        return point;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DBPlugin.getResourceString("dialog.dommain.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(composite, 68354);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        UIUtils.createColumn(table, "dialog.dommain.name", 150);
        UIUtils.createColumn(table, "dialog.dommain.type", 150);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                DommainModel model = (DommainModel)element;
                if (columnIndex == 0) {
                    return model.getName();
                }
                if (columnIndex == 1) {
                    String type = model.getType().getName();
                    if (model.getType().supportSize()) {
                        type = String.valueOf(type) + "(" + model.getSize() + ")";
                    }
                    return type;
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.setInput(this.result);
        Composite buttons = new Composite(composite, 0);
        GridLayout buttonsLayout = new GridLayout(1, false);
        buttonsLayout.horizontalSpacing = 0;
        buttonsLayout.verticalSpacing = 0;
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 2;
        buttons.setLayout((Layout)buttonsLayout);
        buttons.setLayoutData((Object)new GridData(2));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(DBPlugin.getResourceString("dialog.dommain.addDommain"));
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DommainModel dommain = new DommainModel();
                dommain.setName(DBPlugin.getResourceString("dialog.dommain.name"));
                IColumnType defaultType = DommainEditDialog.this.dialect.getDefaultColumnType();
                dommain.setType(defaultType);
                dommain.setSize(defaultType.supportSize() ? "0" : "");
                dommain.setId(DommainEditDialog.this.getDommainId());
                DommainEditDialog.this.result.add(dommain);
                DommainEditDialog.this.viewer.refresh();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(DBPlugin.getResourceString("dialog.dommain.removeDommain"));
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)DommainEditDialog.this.viewer.getSelection();
                List dommains = sel.toList();
                for (DommainModel dommain : dommains) {
                    for (AbstractDBEntityModel entity : DommainEditDialog.this.rootModel.getChildren()) {
                        if (!(entity instanceof TableModel)) continue;
                        TableModel table = (TableModel)entity;
                        ColumnModel[] columnModelArray = table.getColumns();
                        int n = columnModelArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ColumnModel column = columnModelArray[n2];
                            if (column.getDommain() != null && dommain.getId().equals(column.getDommain().getId())) {
                                UIUtils.openAlertDialog("dialog.alert.dommain.delete.error");
                                return;
                            }
                            ++n2;
                        }
                    }
                }
                DommainEditDialog.this.result.removeAll(dommains);
                DommainEditDialog.this.viewer.refresh();
            }
        });
        Composite editArea = new Composite(composite, 0);
        editArea.setLayout((Layout)new GridLayout(4, false));
        editArea.setLayoutData((Object)UIUtils.createGridData(2));
        new Label(editArea, 0).setText(DBPlugin.getResourceString("dialog.dommain.editDommain.name"));
        this.dommainName = new Text(editArea, 2048);
        this.dommainName.setLayoutData((Object)UIUtils.createGridData(3));
        this.dommainName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DommainEditDialog.this.applyToDommainModel();
            }
        });
        new Label(editArea, 0).setText(DBPlugin.getResourceString("dialog.dommain.editDommain.type"));
        this.columnType = new Combo(editArea, 8);
        int i = 0;
        while (i < this.dialect.getColumnTypes().length) {
            IColumnType type = this.dialect.getColumnTypes()[i];
            this.columnType.add(type.toString());
            ++i;
        }
        this.columnType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DommainEditDialog.this.applyToDommainModel();
            }
        });
        this.columnType.setLayoutData((Object)UIUtils.createGridData(1));
        new Label(editArea, 0).setText(DBPlugin.getResourceString("dialog.dommain.editDommain.size"));
        this.columnSize = new Text(editArea, 2048);
        this.columnSize.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DommainEditDialog.this.applyToDommainModel();
            }
        });
        GridData gd = new GridData();
        gd.widthHint = 80;
        this.columnSize.setLayoutData((Object)gd);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DommainEditDialog.this.updateComponents();
            }
        });
        if (this.editingModel != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.editingModel));
        }
        this.updateComponents();
        return composite;
    }

    private void updateComponents() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        this.removeButton.setEnabled(!sel.isEmpty());
        if (sel.isEmpty()) {
            this.editingModel = null;
            this.dommainName.setEnabled(false);
            this.dommainName.setText("");
            this.columnType.setEnabled(false);
            this.columnType.setText("");
            this.columnSize.setEnabled(false);
            this.columnSize.setText("");
        } else {
            this.editingModel = (DommainModel)sel.getFirstElement();
            this.dommainName.setEnabled(true);
            this.dommainName.setText(this.editingModel.getName());
            this.columnType.setEnabled(true);
            this.columnType.setText(this.editingModel.getType().toString());
            this.columnSize.setEnabled(this.editingModel.getType().supportSize());
            this.columnSize.setText(this.editingModel.getSize());
        }
    }

    private void applyToDommainModel() {
        this.editingModel.setName(this.dommainName.getText());
        this.editingModel.setType(this.dialect.getColumnTypes()[this.columnType.getSelectionIndex()]);
        this.editingModel.setSize(this.columnSize.getText());
        this.columnSize.setEnabled(this.editingModel.getType().supportSize());
        this.viewer.refresh();
    }

    private String getDommainId() {
        return String.valueOf(String.valueOf(new Date().getTime())) + this.result.size();
    }

    public List<DommainModel> getResult() {
        return this.result;
    }
}

