/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.editor.VisualDBEditor;
import net.java.amateras.db.visual.generate.IGenerator;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;

public class GenerateAction
extends Action {
    private IGenerator generater;
    private VisualDBEditor editor;
    private GraphicalViewer viewer;

    public GenerateAction(IGenerator generater, GraphicalViewer viewer, VisualDBEditor editor) {
        super(generater.getGeneratorName());
        this.generater = generater;
        this.editor = editor;
        this.viewer = viewer;
    }

    public void run() {
        if (this.editor.isDirty()) {
            if (MessageDialog.openConfirm((Shell)this.editor.getSite().getShell(), (String)DBPlugin.getResourceString("dialog.confirm.title"), (String)DBPlugin.getResourceString("message.saveBeforeExecute"))) {
                this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            } else {
                return;
            }
        }
        RootModel root = (RootModel)this.viewer.getContents().getModel();
        IFileEditorInput input = (IFileEditorInput)this.editor.getEditorInput();
        this.generater.execute(input.getFile(), root, this.viewer);
    }
}

