/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.editor.VisualDBEditor;
import net.java.amateras.db.visual.editpart.TableEditPart;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class LowercaseAction
extends SelectionAction {
    public LowercaseAction(VisualDBEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId(LowercaseAction.class.getName());
        this.setText(DBPlugin.getResourceString("action.toLowercase"));
    }

    public void run() {
        if (!MessageDialog.openConfirm((Shell)this.getWorkbenchPart().getSite().getShell(), (String)DBPlugin.getResourceString("dialog.confirm.title"), (String)DBPlugin.getResourceString("action.toLowercase.confirm"))) {
            return;
        }
        List selection = this.getSelectedObjects();
        int i = 0;
        while (i < selection.size()) {
            EditPart editPart = (EditPart)selection.get(i);
            if (editPart instanceof TableEditPart) {
                TableModel table = (TableModel)editPart.getModel();
                Object[] objectArray = table.getColumns();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnModel column = objectArray[n2];
                    column.setColumnName(column.getColumnName().toLowerCase());
                    ++n2;
                }
                objectArray = table.getIndices();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object index = objectArray[n2];
                    ((IndexModel)index).setIndexName(((IndexModel)index).getIndexName().toLowerCase());
                    ++n2;
                }
                table.setTableName(table.getTableName().toLowerCase());
            }
            ++i;
        }
        UIUtils.getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        int i = 0;
        while (i < selection.size()) {
            Object obj = selection.get(i);
            if (obj instanceof TableEditPart) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

