/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.editor.VisualDBEditor;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ICloneableModel;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteAction
extends SelectionAction {
    public PasteAction(VisualDBEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.PASTE.getId());
        this.setText(DBPlugin.getResourceString("action.paste"));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public void run() {
        List model = (List)Clipboard.getDefault().getContents();
        if (model == null) {
            return;
        }
        CommandStack stack = (CommandStack)((VisualDBEditor)this.getWorkbenchPart()).getAdapter(CommandStack.class);
        stack.execute((Command)new PasteCommand(model));
    }

    private RootModel getRootModel() {
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        RootModel root = (RootModel)viewer.getRootEditPart().getContents().getModel();
        return root;
    }

    private Rectangle getNewRectangle(Rectangle rect) {
        Rectangle newRect = new Rectangle();
        newRect.x = rect.x + 5;
        newRect.y = rect.y + 5;
        newRect.width = rect.width;
        newRect.height = rect.height;
        return newRect;
    }

    protected boolean calculateEnabled() {
        Object obj = Clipboard.getDefault().getContents();
        if (obj == null) {
            return false;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            int i = 0;
            while (i < list.size()) {
                Object element = list.get(i);
                if (ICloneableModel.class.isAssignableFrom(element.getClass())) {
                    return true;
                }
                ++i;
            }
        }
        return true;
    }

    private class PasteCommand
    extends Command {
        private List<ICloneableModel> target;

        public PasteCommand(List<ICloneableModel> target) {
            this.target = target;
        }

        public void execute() {
            ArrayList<ICloneableModel> copied = new ArrayList<ICloneableModel>();
            int i = 0;
            while (i < this.target.size()) {
                ICloneableModel obj = this.target.get(i);
                AbstractDBEntityModel entity = (AbstractDBEntityModel)((Object)obj);
                entity.setConstraint(PasteAction.this.getNewRectangle(entity.getConstraint()));
                PasteAction.this.getRootModel().addChild((AbstractDBEntityModel)((Object)obj));
                copied.add(obj.clone());
                ++i;
            }
            Clipboard.getDefault().setContents(copied);
        }

        public void undo() {
            int i = 0;
            while (i < this.target.size()) {
                ICloneableModel obj = this.target.get(i);
                PasteAction.this.getRootModel().removeChild((AbstractDBEntityModel)((Object)obj));
                ++i;
            }
            Clipboard.getDefault().setContents(this.target);
        }
    }
}

