/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.ModelUtils;
import net.java.amateras.db.visual.editor.VisualDBSerializer;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RefreshLinkedTablesAction
extends Action {
    private GraphicalViewer viewer;
    private Map<String, RootModel> models = new HashMap<String, RootModel>();

    public RefreshLinkedTablesAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.refreshLinkedTables"));
        this.viewer = viewer;
        this.setImageDescriptor(DBPlugin.getImageDescriptor("icons/refresh.gif"));
    }

    private TableModel getNewTable(TableModel oldTable) throws Exception {
        String path = oldTable.getLinkedPath();
        if (this.models.containsKey(path)) {
            return this.models.get(path).getTable(oldTable.getTableName());
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        RootModel root = VisualDBSerializer.deserialize(file.getContents());
        this.models.put(path, root);
        return root.getTable(oldTable.getTableName());
    }

    public void run() {
        final RootModel root = (RootModel)this.viewer.getContents().getModel();
        final ArrayList<TableModel> oldTables = new ArrayList<TableModel>();
        for (AbstractDBEntityModel child : root.getChildren()) {
            TableModel table;
            if (!(child instanceof TableModel) || !(table = (TableModel)child).isLinkedTable()) continue;
            oldTables.add(table);
        }
        if (oldTables.isEmpty()) {
            MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)DBPlugin.getResourceString("dialog.info.title"), (String)DBPlugin.getResourceString("action.refreshLinkedTables.noLinkedTable"));
            return;
        }
        CommandStack stack = this.viewer.getEditDomain().getCommandStack();
        stack.execute(new Command(){

            public void execute() {
                for (TableModel oldTable : oldTables) {
                    try {
                        TableModel newTable = RefreshLinkedTablesAction.this.getNewTable(oldTable);
                        if (newTable == null) continue;
                        ModelUtils.importOrReplaceTable(root, oldTable, newTable);
                        newTable.setLinkedPath(oldTable.getLinkedPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                RefreshLinkedTablesAction.this.models.clear();
            }

            public boolean canUndo() {
                return false;
            }
        });
    }
}

