/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import java.util.ArrayList;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.sqleditor.SQLConfiguration;
import net.java.amateras.db.sqleditor.SQLPartitionScanner;
import net.java.amateras.db.visual.editpart.TableEditPart;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SelectedTablesDDLAction
extends Action {
    private GraphicalViewer viewer;

    public SelectedTablesDDLAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.selectedTablesDDL"));
        this.viewer = viewer;
    }

    public void run() {
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object[] selected;
            ArrayList<TableModel> tableModels = new ArrayList<TableModel>();
            Object[] objectArray = selected = ((IStructuredSelection)sel).toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof TableEditPart) {
                    tableModels.add((TableModel)((TableEditPart)obj).getModel());
                }
                ++n2;
            }
            RootModel root = (RootModel)this.viewer.getContents().getModel();
            IDialect dialect = DialectProvider.getDialect(root.getDialectName());
            StringBuilder sb = new StringBuilder();
            if (tableModels.isEmpty()) {
                sb.append(dialect.createDDL(root, true, false, true, true));
            } else {
                StringBuilder additions = new StringBuilder();
                for (TableModel tableModel : tableModels) {
                    sb.append(dialect.createTableDDL(root, tableModel, false, false, true, true, additions));
                }
                if (additions.length() > 0) {
                    sb.append(System.getProperty("line.separator"));
                    sb.append(additions.toString());
                }
            }
            DDLDisplayDialog dialog = new DDLDisplayDialog(Display.getDefault().getActiveShell(), sb.toString());
            dialog.open();
        }
    }

    private class DDLDisplayDialog
    extends Dialog {
        private String ddl;

        protected DDLDisplayDialog(Shell parentShell, String ddl) {
            super(parentShell);
            this.ddl = ddl;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Point getInitialSize() {
            return new Point(600, 450);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("DDL");
            SourceViewer sqlEditor = new SourceViewer(parent, (IVerticalRuler)new VerticalRuler(0), 768);
            sqlEditor.configure((SourceViewerConfiguration)new SQLConfiguration());
            sqlEditor.getTextWidget().setFont(JFaceResources.getTextFont());
            Document document = new Document();
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(), new String[]{"__sql_comment", "__sql_string"});
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            sqlEditor.setDocument((IDocument)document);
            sqlEditor.getControl().setLayoutData((Object)new GridData(1808));
            StyledText text = sqlEditor.getTextWidget();
            text.setText(this.ddl);
            text.setEditable(false);
            return text;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

