/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.action;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.validator.DiagramErrors;
import net.java.amateras.db.validator.DiagramValidator;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IFileEditorInput;

public class ValidateAction
extends Action {
    private GraphicalViewer viewer;

    public ValidateAction(GraphicalViewer viewer) {
        super(DBPlugin.getResourceString("action.validation.executeValidation"));
        this.viewer = viewer;
    }

    public void run() {
        CommandStack stack = this.viewer.getEditDomain().getCommandStack();
        stack.execute(new Command("Validation"){

            public boolean canUndo() {
                return false;
            }

            public void execute() {
                try {
                    RootModel model = (RootModel)ValidateAction.this.viewer.getContents().getModel();
                    IFile file = ((IFileEditorInput)UIUtils.getActiveEditor().getEditorInput()).getFile();
                    file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                    DiagramErrors errors = new DiagramValidator(model).doValidate();
                    for (DiagramErrors.DiagramError error : errors.getErrors()) {
                        error.addMarker(file);
                    }
                }
                catch (CoreException ex) {
                    DBPlugin.logException((Exception)((Object)ex));
                }
            }
        });
    }
}

