/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editor;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.action.DommainEditAction;
import net.java.amateras.db.visual.editpart.TableEditPart;
import net.java.amateras.db.visual.editpart.tree.FolderTreeEditPart;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.DommainModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;

public class ModelEditor {
    private GraphicalViewer viewer;
    private boolean editTable;

    public ModelEditor(GraphicalViewer viewer, boolean editTable) {
        this.viewer = viewer;
        this.editTable = editTable;
    }

    public void editModel(Object model) {
        EditPart rootEditPart = this.viewer.getContents();
        RootModel rootModel = (RootModel)rootEditPart.getModel();
        if (model instanceof TableModel) {
            if (this.editTable) {
                TableModel table = (TableModel)model;
                if (table.isLinkedTable()) {
                    UIUtils.openAlertDialog(DBPlugin.getResourceString("error.edit.linkedTable"));
                    return;
                }
                TableEditPart.openTableEditDialog((EditPartViewer)this.viewer, table, rootModel);
            } else {
                EditPart select = this.getSelectEditPart(rootEditPart, model);
                if (select != null) {
                    this.viewer.select(select);
                    this.viewer.reveal(select);
                }
            }
        } else if (model instanceof DommainModel) {
            new DommainEditAction((GraphicalViewer)UIUtils.getActiveEditor().getAdapter(GraphicalViewer.class), (DommainModel)model).run();
        } else if (model instanceof ColumnModel) {
            TableModel parent = null;
            block0: for (AbstractDBEntityModel entity : rootModel.getChildren()) {
                if (!(entity instanceof TableModel)) continue;
                TableModel table = (TableModel)entity;
                ColumnModel[] columnModelArray = table.getColumns();
                int n = columnModelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnModel column = columnModelArray[n2];
                    if (column == model) {
                        parent = table;
                        break block0;
                    }
                    ++n2;
                }
            }
            if (parent != null) {
                if (parent.isLinkedTable()) {
                    UIUtils.openAlertDialog(DBPlugin.getResourceString("error.edit.linkedTable"));
                    return;
                }
                TableEditPart.openTableEditDialog((EditPartViewer)this.viewer, parent, rootModel, (ColumnModel)model);
            }
        } else if (model instanceof FolderTreeEditPart.FolderModel) {
            ((FolderTreeEditPart.FolderModel)model).doEdit();
        } else if (model instanceof IndexModel) {
            TableModel parent = null;
            block2: for (AbstractDBEntityModel entity : rootModel.getChildren()) {
                if (!(entity instanceof TableModel)) continue;
                TableModel table = (TableModel)entity;
                IndexModel[] indexModelArray = table.getIndices();
                int n = indexModelArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IndexModel index = indexModelArray[n3];
                    if (index == model) {
                        parent = table;
                        break block2;
                    }
                    ++n3;
                }
            }
            if (parent != null) {
                TableEditPart.openTableEditDialog((EditPartViewer)this.viewer, parent, rootModel, (IndexModel)model);
            }
        }
    }

    private EditPart getSelectEditPart(EditPart part, Object model) {
        if (part.getModel() == model) {
            return part;
        }
        for (Object child : part.getChildren()) {
            EditPart result = this.getSelectEditPart((EditPart)child, model);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

