/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editor;

import java.util.List;
import net.java.amateras.db.visual.editor.ModelEditor;
import net.java.amateras.db.visual.editpart.tree.AbstractDBTreeEditPart;
import net.java.amateras.db.visual.editpart.tree.VisualDBTreeEditPartFactory;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VisualDBOutlinePage
extends ContentOutlinePage {
    private GraphicalViewer graphicalViewer;
    private EditDomain editDomain;
    private RootModel rootModel;
    private SelectionSynchronizer selectionSynchronizer;
    private Composite composite;
    private SashForm sashForm;
    private DisposeListener disposeListener;
    private ScrollableThumbnail thumbnail;
    private Text search;
    private ModelEditor modelEditor;
    private static String filterText = "";

    public VisualDBOutlinePage(GraphicalViewer viewer, EditDomain domain, RootModel root, SelectionSynchronizer selectionSynchronizer) {
        super((EditPartViewer)new TreeViewer());
        this.graphicalViewer = viewer;
        this.editDomain = domain;
        this.rootModel = root;
        this.selectionSynchronizer = selectionSynchronizer;
        this.modelEditor = new ModelEditor(this.graphicalViewer, true);
    }

    public static String getFilterText() {
        return filterText;
    }

    public static void setFilterText(String filterText) {
        VisualDBOutlinePage.filterText = filterText;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.search = new Text(this.composite, 2048);
        this.search.setLayoutData((Object)new GridData(768));
        this.search.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditPart folder;
                List tables;
                filterText = VisualDBOutlinePage.this.search.getText();
                VisualDBOutlinePage.this.getViewer().getRootEditPart().getContents().refresh();
                if (filterText.length() > 0 && (tables = (folder = (EditPart)VisualDBOutlinePage.this.getViewer().getRootEditPart().getContents().getChildren().get(0)).getChildren()).size() > 0) {
                    VisualDBOutlinePage.this.getViewer().select((EditPart)tables.get(0));
                }
            }
        });
        this.sashForm = new SashForm(this.composite, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        EditPartViewer viewer = this.getViewer();
        viewer.createControl((Composite)this.sashForm);
        viewer.setEditDomain(this.editDomain);
        viewer.setEditPartFactory((EditPartFactory)new VisualDBTreeEditPartFactory());
        viewer.setContents((Object)this.rootModel);
        this.selectionSynchronizer.addViewer(viewer);
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection sel = (IStructuredSelection)VisualDBOutlinePage.this.getViewer().getSelection();
                Object obj = sel.getFirstElement();
                if (obj != null) {
                    AbstractDBTreeEditPart editPart = (AbstractDBTreeEditPart)obj;
                    Object model = editPart.getModel();
                    VisualDBOutlinePage.this.modelEditor.editModel(model);
                }
            }
        });
        Canvas canvas = new Canvas((Composite)this.sashForm, 2048);
        LightweightSystem lws = new LightweightSystem(canvas);
        ScalableRootEditPart rootEditPart = (ScalableRootEditPart)this.graphicalViewer.getRootEditPart();
        this.thumbnail = new ScrollableThumbnail((Viewport)rootEditPart.getFigure());
        this.thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
        lws.setContents((IFigure)this.thumbnail);
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (VisualDBOutlinePage.this.thumbnail != null) {
                    VisualDBOutlinePage.this.thumbnail.deactivate();
                    VisualDBOutlinePage.this.thumbnail = null;
                }
            }
        };
        this.graphicalViewer.getControl().addDisposeListener(this.disposeListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    public Control getControl() {
        return this.composite;
    }

    public void dispose() {
        this.selectionSynchronizer.removeViewer(this.getViewer());
        if (this.graphicalViewer.getControl() != null && !this.graphicalViewer.getControl().isDisposed()) {
            this.graphicalViewer.getControl().removeDisposeListener(this.disposeListener);
        }
        super.dispose();
    }
}

