/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.visual.editpart.AbstractDBEditPart;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class AbstractDBEntityEditPart
extends AbstractDBEditPart
implements NodeEditPart {
    protected CreateConnectionCommand newCreateConnectionCommand() {
        return new CreateConnectionCommand();
    }

    protected void refreshVisuals() {
        Object model = this.getModel();
        if (model instanceof AbstractDBEntityModel) {
            Rectangle constraint = ((AbstractDBEntityModel)model).getConstraint();
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TableComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    protected List<AbstractDBConnectionModel> getModelSourceConnections() {
        return ((AbstractDBEntityModel)this.getModel()).getModelSourceConnections();
    }

    protected List<AbstractDBConnectionModel> getModelTargetConnections() {
        return ((AbstractDBEntityModel)this.getModel()).getModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.invokePropertyChangeListener(evt, this.getSourceConnections());
        this.invokePropertyChangeListener(evt, this.getTargetConnections());
    }

    private void invokePropertyChangeListener(PropertyChangeEvent evt, List<PropertyChangeListener> listeners) {
        for (PropertyChangeListener listener : listeners) {
            listener.propertyChange(evt);
        }
    }

    protected static class CreateConnectionCommand
    extends Command {
        protected Object model;
        protected AbstractDBEntityModel source;
        protected AbstractDBEntityModel target;
        protected AbstractDBConnectionModel connection;

        protected CreateConnectionCommand() {
        }

        public void setModel(Object model) {
            this.model = model;
        }

        public Object getModel() {
            return this.model;
        }

        public AbstractDBConnectionModel getConnectionModel() {
            return this.connection;
        }

        public boolean canExecute() {
            if (this.source == null || this.target == null) {
                return false;
            }
            return this.source != this.target;
        }

        public void execute() {
            this.connection.attachSource();
            this.connection.attachTarget();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractDBConnectionModel)model;
        }

        public void setSource(Object model) {
            this.source = (AbstractDBEntityModel)model;
            this.connection.setSource(this.source);
        }

        public void setTarget(Object model) {
            this.target = (AbstractDBEntityModel)model;
            this.connection.setTarget(this.target);
        }

        public void undo() {
            this.connection.detachSource();
            this.connection.detachTarget();
        }
    }

    private class DeleteCommand
    extends Command {
        private RootModel root;
        private AbstractDBEntityModel model;
        private List<AbstractDBConnectionModel> sourceConnections = new ArrayList<AbstractDBConnectionModel>();
        private List<AbstractDBConnectionModel> targetConnections = new ArrayList<AbstractDBConnectionModel>();

        private DeleteCommand() {
        }

        public void execute() {
            AbstractDBConnectionModel model;
            this.sourceConnections.addAll(this.model.getModelSourceConnections());
            this.targetConnections.addAll(this.model.getModelTargetConnections());
            int i = 0;
            while (i < this.sourceConnections.size()) {
                model = this.sourceConnections.get(i);
                model.detachSource();
                model.detachTarget();
                ++i;
            }
            i = 0;
            while (i < this.targetConnections.size()) {
                model = this.targetConnections.get(i);
                model.detachSource();
                model.detachTarget();
                ++i;
            }
            this.root.removeChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setTargetModel(Object model) {
            this.model = (AbstractDBEntityModel)model;
        }

        public void undo() {
            AbstractDBConnectionModel model;
            this.root.addChild(this.model);
            int i = 0;
            while (i < this.sourceConnections.size()) {
                model = this.sourceConnections.get(i);
                model.attachSource();
                model.attachTarget();
                ++i;
            }
            i = 0;
            while (i < this.targetConnections.size()) {
                model = this.targetConnections.get(i);
                model.attachSource();
                model.attachTarget();
                ++i;
            }
            this.sourceConnections.clear();
            this.targetConnections.clear();
        }
    }

    private class EntityLayoutEditPolicy
    extends LayoutEditPolicy {
        private EntityLayoutEditPolicy() {
        }

        protected Command getMoveChildrenCommand(Request request) {
            return null;
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }

    private class NodeEditPolicy
    extends GraphicalNodeEditPolicy {
        private NodeEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            AbstractDBConnectionModel conn = ((CreateConnectionCommand)request.getStartCommand()).getConnectionModel();
            AbstractDBEntityModel model = (AbstractDBEntityModel)this.getHost().getModel();
            if (!model.canTarget(conn)) {
                return null;
            }
            CreateConnectionCommand command = (CreateConnectionCommand)request.getStartCommand();
            command.setTarget(model);
            return command;
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            AbstractDBConnectionModel conn = (AbstractDBConnectionModel)request.getNewObject();
            AbstractDBEntityModel model = (AbstractDBEntityModel)this.getHost().getModel();
            if (!model.canSource(conn)) {
                return null;
            }
            CreateConnectionCommand command = AbstractDBEntityEditPart.this.newCreateConnectionCommand();
            command.setModel(AbstractDBEntityEditPart.this.getModel());
            command.setConnection(conn);
            command.setSource(model);
            request.setStartCommand((Command)command);
            return command;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            AbstractDBConnectionModel conn = (AbstractDBConnectionModel)request.getConnectionEditPart().getModel();
            AbstractDBEntityModel model = (AbstractDBEntityModel)this.getHost().getModel();
            if (!model.canTarget(conn)) {
                return null;
            }
            ReconnectTargetCommand command = new ReconnectTargetCommand();
            command.setConnection(conn);
            command.setTarget(model);
            return command;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            AbstractDBConnectionModel conn = (AbstractDBConnectionModel)request.getConnectionEditPart().getModel();
            AbstractDBEntityModel model = (AbstractDBEntityModel)this.getHost().getModel();
            if (!model.canSource(conn)) {
                return null;
            }
            ReconnectSourceCommand command = new ReconnectSourceCommand();
            command.setConnection(conn);
            command.setSource(model);
            return command;
        }
    }

    private class ReconnectSourceCommand
    extends Command {
        private AbstractDBEntityModel source;
        private AbstractDBEntityModel oldSource;
        private AbstractDBConnectionModel connection;

        private ReconnectSourceCommand() {
        }

        public void execute() {
            this.connection.detachSource();
            this.connection.setSource(this.source);
            this.connection.attachSource();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractDBConnectionModel)model;
            this.oldSource = this.connection.getSource();
        }

        public void setSource(Object model) {
            this.source = (AbstractDBEntityModel)model;
        }

        public boolean canExecute() {
            if (this.connection.getTarget() == null || this.source == null) {
                return false;
            }
            return !this.connection.getTarget().equals(this.source);
        }

        public void undo() {
            this.connection.detachSource();
            this.connection.setSource(this.oldSource);
            this.connection.attachSource();
        }
    }

    private class ReconnectTargetCommand
    extends Command {
        private AbstractDBEntityModel target;
        private AbstractDBEntityModel oldTarget;
        private AbstractDBConnectionModel connection;

        private ReconnectTargetCommand() {
        }

        public void execute() {
            this.connection.detachTarget();
            this.connection.setTarget(this.target);
            this.connection.attachTarget();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractDBConnectionModel)model;
            this.oldTarget = this.connection.getTarget();
        }

        public void setTarget(Object model) {
            this.target = (AbstractDBEntityModel)model;
        }

        public boolean canExecute() {
            if (this.connection.getSource() == null || this.target == null) {
                return false;
            }
            return !this.connection.getSource().equals(this.target);
        }

        public void undo() {
            this.connection.detachTarget();
            this.connection.setTarget(this.oldTarget);
            this.connection.attachTarget();
        }
    }

    private class TableComponentEditPolicy
    extends ComponentEditPolicy {
        private TableComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setRootModel(this.getHost().getParent().getModel());
            command.setTargetModel(this.getHost().getModel());
            return command;
        }
    }
}

