/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.editpart.AbstractDBConnectionEditPart;
import net.java.amateras.db.visual.editpart.AbstractDBEditPart;
import net.java.amateras.db.visual.editpart.AbstractDBEntityEditPart;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.NoteModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class RootEditPart
extends AbstractDBEditPart {
    private Set<Class<? extends AbstractDBEntityModel>> RESIZABLE = new HashSet<Class<? extends AbstractDBEntityModel>>();

    public RootEditPart() {
        this.RESIZABLE.add(NoteModel.class);
    }

    protected IFigure createFigure() {
        Layer figure = new Layer();
        figure.setLayoutManager((LayoutManager)new XYLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RootEditPolicy());
    }

    protected List<AbstractDBEntityModel> getModelChildren() {
        return ((RootModel)this.getModel()).getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        List children;
        if (evt.getPropertyName().equals("p_children")) {
            this.refreshChildren();
        }
        if (evt.getPropertyName().equals("p_font")) {
            children = this.getChildren();
            for (AbstractDBEntityEditPart part : children) {
                part.refresh();
                for (Object conn : part.getSourceConnections()) {
                    ((AbstractDBConnectionEditPart)conn).refresh();
                }
            }
        }
        if (evt.getPropertyName().equals("p_mode")) {
            children = this.getChildren();
            for (AbstractDBEntityEditPart part : children) {
                part.refresh();
                List conns = part.getSourceConnections();
                for (AbstractDBConnectionEditPart conn : conns) {
                    conn.refresh();
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return (SnapToHelper)snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    private class ChangeConstraintCommand
    extends Command {
        private AbstractDBEntityModel model;
        private Rectangle constraint;
        private Rectangle oldConstraint;

        private ChangeConstraintCommand() {
        }

        public void execute() {
            this.model.setConstraint(this.constraint);
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public void setModel(AbstractDBEntityModel model) {
            this.model = model;
            this.oldConstraint = model.getConstraint();
        }

        public void undo() {
            this.model.setConstraint(this.oldConstraint);
        }
    }

    private class CreateCommand
    extends Command {
        private RootModel root;
        private AbstractDBEntityModel model;

        private CreateCommand() {
        }

        public void execute() {
            this.root.addChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setModel(Object model) {
            this.model = (AbstractDBEntityModel)model;
            if (this.model instanceof TableModel) {
                ((TableModel)this.model).setTableName("TABLE_" + (this.root.getChildren().size() + 1));
                ((TableModel)this.model).setLogicalName(String.valueOf(DBPlugin.getResourceString("label.table")) + (this.root.getChildren().size() + 1));
            }
        }

        public void undo() {
            this.root.removeChild(this.model);
        }
    }

    private class RootEditPolicy
    extends XYLayoutEditPolicy {
        private RootEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            if (RootEditPart.this.RESIZABLE.contains(child.getModel().getClass())) {
                return new ResizableEditPolicy();
            }
            return new NonResizableEditPolicy();
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            command.setModel((AbstractDBEntityModel)child.getModel());
            command.setConstraint((Rectangle)constraint);
            return command;
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateCommand command = new CreateCommand();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            AbstractDBEntityModel model = (AbstractDBEntityModel)request.getNewObject();
            if (!RootEditPart.this.RESIZABLE.contains(model.getClass())) {
                constraint.width = -1;
                constraint.height = -1;
            }
            model.setConstraint(constraint);
            command.setRootModel(this.getHost().getModel());
            command.setModel(model);
            return command;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }
}

