/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.dialect.IIndexType;
import net.java.amateras.db.dialect.IndexType;
import net.java.amateras.db.sqleditor.SQLConfiguration;
import net.java.amateras.db.sqleditor.SQLPartitionScanner;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.editpart.ColumnSelectDialog;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.DommainModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableEditDialog
extends Dialog {
    private String tableName;
    private String tableLogicalName;
    private String tableDescription;
    private List<ColumnModel> columnModels = new ArrayList<ColumnModel>();
    private int editColumnIndex = -1;
    private String sql;
    private Text txtTableName;
    private Text txtTableLogicalName;
    private Text txtTableDescription;
    private Table tblColumns;
    private Text txtColumnName;
    private Text txtColumnLogicalName;
    private Combo cmbColumnType;
    private Text txtColumnSize;
    private Button chkNotNull;
    private Button chkIsPK;
    private Button autoIncrement;
    private Text defaultValue;
    private Text txtColumnDescription;
    private org.eclipse.swt.widgets.List indexList;
    private Text indexName;
    private Combo indexType;
    private org.eclipse.swt.widgets.List selectedColumns;
    private StyledText txtSql;
    private List<IndexModel> indexModels = new ArrayList<IndexModel>();
    private int editIndexIndex = -1;
    private RootModel rootModel;
    private IDialect dialect;
    private FocusListener updateColumnListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            TableEditDialog.this.updateColumn();
        }
    };
    private SelectionListener updateColumnListener2 = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableEditDialog.this.updateColumn();
        }
    };
    private Button btnDelColumn;
    private Button btnUpColumn;
    private Button btnDownColumn;
    private Button btnAddColumn;
    private Button addIndex;
    private Button delIndex;
    private Button indexUpButton;
    private Button indexDownButton;
    private Button indexAddButton;
    private Button indexRemoveButton;
    private boolean indexEditing = false;

    public TableEditDialog(Shell parentShell, RootModel rootModel, String tableName, String tableLogicalName, String tableDescription, ColumnModel[] columns, ColumnModel editColumn, IndexModel[] indices, boolean indexEditing, IndexModel editIndex, String sql) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tableName = tableName;
        this.tableLogicalName = tableLogicalName;
        this.tableDescription = tableDescription;
        this.rootModel = rootModel;
        this.dialect = DialectProvider.getDialect(rootModel.getDialectName());
        int i = 0;
        while (i < columns.length) {
            this.columnModels.add(columns[i]);
            if (editColumn != null && editColumn == columns[i]) {
                this.editColumnIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            this.indexModels.add(indices[i]);
            if (editIndex != null && indices[i] == editIndex) {
                this.editIndexIndex = i;
            }
            ++i;
        }
        this.indexEditing = indexEditing;
        this.sql = sql;
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        shell.pack();
        shell.setSize(shell.getSize().x, 450);
    }

    private void syncColumnModelsToTable() {
        this.tblColumns.removeAll();
        int j = 0;
        while (j < this.columnModels.size()) {
            ColumnModel model = this.columnModels.get(j);
            TableItem item = new TableItem(this.tblColumns, 0);
            this.updateTableItem(item, model);
            ++j;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DBPlugin.getResourceString("dialog.table.title"));
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tab1 = new TabItem(tabFolder, 0);
        tab1.setText(DBPlugin.getResourceString("label.table"));
        Composite composite1 = new Composite((Composite)tabFolder, 0);
        composite1.setLayout((Layout)new GridLayout(2, false));
        composite1.setLayoutData((Object)new GridData(1808));
        tab1.setControl((Control)composite1);
        UIUtils.createLabel(composite1, "dialog.table.tableLogicalName");
        this.txtTableLogicalName = new Text(composite1, 2048);
        this.txtTableLogicalName.setLayoutData((Object)new GridData(768));
        this.txtTableLogicalName.setText(this.tableLogicalName);
        UIUtils.createLabel(composite1, "dialog.table.tableName");
        this.txtTableName = new Text(composite1, 2048);
        this.txtTableName.setLayoutData((Object)new GridData(768));
        this.txtTableName.setText(this.tableName);
        UIUtils.createLabel(composite1, "dialog.table.description");
        this.txtTableDescription = new Text(composite1, 2818);
        this.txtTableDescription.setLayoutData((Object)new GridData(1808));
        this.txtTableDescription.setText(this.tableDescription);
        TabItem tab2 = new TabItem(tabFolder, 0);
        tab2.setText(DBPlugin.getResourceString("label.column"));
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        tab2.setControl((Control)composite2);
        Composite tableArea = new Composite(composite2, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableArea.setLayout((Layout)layout);
        tableArea.setLayoutData((Object)new GridData(1808));
        this.tblColumns = new Table(tableArea, 67588);
        this.tblColumns.setLayoutData((Object)new GridData(1808));
        this.tblColumns.setHeaderVisible(true);
        UIUtils.createColumn(this.tblColumns, "dialog.table.columnLogicalName", 150);
        UIUtils.createColumn(this.tblColumns, "dialog.table.columnName", 150);
        UIUtils.createColumn(this.tblColumns, "dialog.table.columnType", 150);
        UIUtils.createColumn(this.tblColumns, "dialog.table.columnPK", 40);
        UIUtils.createColumn(this.tblColumns, "dialog.table.columnNotNull", 40);
        int i = 0;
        while (i < this.columnModels.size()) {
            ColumnModel model = this.columnModels.get(i);
            TableItem item = new TableItem(this.tblColumns, 0);
            this.updateTableItem(item, model);
            ++i;
        }
        this.tblColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditDialog.this.tableSelectionChanged();
            }
        });
        Composite buttons = new Composite(tableArea, 0);
        GridLayout buttonsLayout = new GridLayout(1, false);
        buttonsLayout.horizontalSpacing = 0;
        buttonsLayout.verticalSpacing = 0;
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 2;
        buttons.setLayout((Layout)buttonsLayout);
        buttons.setLayoutData((Object)new GridData(2));
        this.btnAddColumn = new Button(buttons, 8);
        this.btnAddColumn.setText(DBPlugin.getResourceString("dialog.table.addColumn"));
        this.btnAddColumn.setLayoutData((Object)new GridData(768));
        this.btnAddColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnModel column = new ColumnModel();
                column.setColumnName("COLUMN_" + (TableEditDialog.this.columnModels.size() + 1));
                column.setLogicalName(String.valueOf(DBPlugin.getResourceString("label.column")) + (TableEditDialog.this.columnModels.size() + 1));
                column.setColumnType(TableEditDialog.this.dialect.getDefaultColumnType());
                column.setSize("10");
                int i = TableEditDialog.this.tblColumns.getSelectionIndex();
                if (i == -1) {
                    TableEditDialog.this.columnModels.add(column);
                    TableItem item = new TableItem(TableEditDialog.this.tblColumns, 0);
                    TableEditDialog.this.updateTableItem(item, column);
                    TableEditDialog.this.tblColumns.setSelection(TableEditDialog.this.columnModels.size() - 1);
                    TableEditDialog.this.tableSelectionChanged();
                } else {
                    TableEditDialog.this.columnModels.add(i + 1, column);
                    TableEditDialog.this.syncColumnModelsToTable();
                    TableEditDialog.this.tblColumns.setSelection(i + 1);
                    TableEditDialog.this.tableSelectionChanged();
                }
            }
        });
        this.btnDelColumn = new Button(buttons, 8);
        this.btnDelColumn.setText(DBPlugin.getResourceString("dialog.table.removeColumn"));
        this.btnDelColumn.setLayoutData((Object)new GridData(768));
        this.btnDelColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditDialog.this.columnModels.remove(TableEditDialog.this.tblColumns.getSelectionIndex());
                TableEditDialog.this.tblColumns.remove(TableEditDialog.this.tblColumns.getSelectionIndex());
                TableEditDialog.this.disableColumnForm();
                TableEditDialog.this.updateButtons();
            }
        });
        this.btnUpColumn = new Button(buttons, 8);
        this.btnUpColumn.setText(DBPlugin.getResourceString("dialog.table.upColumn"));
        this.btnUpColumn.setLayoutData((Object)new GridData(768));
        this.btnUpColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = TableEditDialog.this.tblColumns.getSelectionIndex();
                ColumnModel column = (ColumnModel)TableEditDialog.this.columnModels.get(i);
                TableEditDialog.this.columnModels.remove(i);
                TableEditDialog.this.columnModels.add(i - 1, column);
                TableEditDialog.this.syncColumnModelsToTable();
                TableEditDialog.this.tblColumns.setSelection(i - 1);
                TableEditDialog.this.tableSelectionChanged();
            }
        });
        this.btnDownColumn = new Button(buttons, 8);
        this.btnDownColumn.setText(DBPlugin.getResourceString("dialog.table.downColumn"));
        this.btnDownColumn.setLayoutData((Object)new GridData(768));
        this.btnDownColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = TableEditDialog.this.tblColumns.getSelectionIndex();
                ColumnModel column = (ColumnModel)TableEditDialog.this.columnModels.get(i);
                TableEditDialog.this.columnModels.remove(i);
                TableEditDialog.this.columnModels.add(i + 1, column);
                TableEditDialog.this.syncColumnModelsToTable();
                TableEditDialog.this.tblColumns.setSelection(i + 1);
                TableEditDialog.this.tableSelectionChanged();
            }
        });
        Group group = new Group(composite2, 0);
        group.setText(DBPlugin.getResourceString("dialog.table.editColumn"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(6, false));
        UIUtils.createLabel((Composite)group, "dialog.table.editColumn.logicalName");
        this.txtColumnLogicalName = new Text((Composite)group, 2048);
        this.txtColumnLogicalName.setLayoutData((Object)new GridData(768));
        this.txtColumnLogicalName.addFocusListener(this.updateColumnListener);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        UIUtils.createLabel((Composite)group, "dialog.table.editColumn.name");
        this.txtColumnName = new Text((Composite)group, 2048);
        this.txtColumnName.setLayoutData((Object)new GridData(768));
        this.txtColumnName.addFocusListener(this.updateColumnListener);
        UIUtils.createLabel((Composite)group, "dialog.table.editColumn.type");
        this.cmbColumnType = new Combo((Composite)group, 8);
        for (DommainModel domman : this.rootModel.getDommains()) {
            this.cmbColumnType.add(domman.toString());
        }
        int i2 = 0;
        while (i2 < this.dialect.getColumnTypes().length) {
            IColumnType type = this.dialect.getColumnTypes()[i2];
            this.cmbColumnType.add(type.toString());
            ++i2;
        }
        this.cmbColumnType.addSelectionListener(this.updateColumnListener2);
        UIUtils.createLabel((Composite)group, "dialog.table.editColumn.size");
        this.txtColumnSize = new Text((Composite)group, 2048);
        this.txtColumnSize.setLayoutData((Object)UIUtils.createGridDataWithWidth(60));
        this.txtColumnSize.addFocusListener(this.updateColumnListener);
        UIUtils.createLabel((Composite)group, "dialog.table.description");
        this.txtColumnDescription = new Text((Composite)group, 2818);
        this.txtColumnDescription.setLayoutData((Object)UIUtils.createGridDataWithColspan(5, 40));
        this.txtColumnDescription.addFocusListener(this.updateColumnListener);
        Composite checks = new Composite((Composite)group, 0);
        checks.setLayout((Layout)new GridLayout(5, false));
        checks.setLayoutData((Object)UIUtils.createGridData(6));
        this.chkIsPK = new Button(checks, 32);
        this.chkIsPK.setText(DBPlugin.getResourceString("dialog.table.editColumn.PK"));
        this.chkIsPK.addSelectionListener(this.updateColumnListener2);
        this.chkNotNull = new Button(checks, 32);
        this.chkNotNull.setText(DBPlugin.getResourceString("dialog.table.editColumn.notNull"));
        this.chkNotNull.addSelectionListener(this.updateColumnListener2);
        this.autoIncrement = new Button(checks, 32);
        this.autoIncrement.setText(DBPlugin.getResourceString("dialog.table.editColumn.autoIncrement"));
        this.autoIncrement.addSelectionListener(this.updateColumnListener2);
        new Label(checks, 0).setText(DBPlugin.getResourceString("dialog.table.editColumn.defaultValue"));
        this.defaultValue = new Text(checks, 2048);
        this.defaultValue.setLayoutData((Object)UIUtils.createGridDataWithWidth(60));
        this.defaultValue.addFocusListener(this.updateColumnListener);
        if (this.editColumnIndex >= 0) {
            tabFolder.setSelection(tab2);
            this.tblColumns.select(this.editColumnIndex);
            this.tableSelectionChanged();
        } else {
            this.disableColumnForm();
        }
        this.updateButtons();
        TabItem tab3 = new TabItem(tabFolder, 0);
        tab3.setText(DBPlugin.getResourceString("label.index"));
        Composite composite3 = new Composite((Composite)tabFolder, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(1808));
        tab3.setControl((Control)composite3);
        Composite indexArea = new Composite(composite3, 0);
        indexArea.setLayout((Layout)layout);
        indexArea.setLayoutData((Object)UIUtils.createGridData(2, 1808));
        this.indexList = new org.eclipse.swt.widgets.List(indexArea, 2816);
        this.indexList.setLayoutData((Object)new GridData(1808));
        for (IndexModel index : this.indexModels) {
            this.indexList.add(index.toString());
        }
        this.indexList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditDialog.this.indexSelectionChanged();
            }
        });
        Composite indexButtons = new Composite(indexArea, 0);
        indexButtons.setLayout((Layout)buttonsLayout);
        indexButtons.setLayoutData((Object)new GridData(2));
        this.addIndex = new Button(indexButtons, 8);
        this.addIndex.setText(DBPlugin.getResourceString("dialog.table.addIndex"));
        this.addIndex.setLayoutData((Object)new GridData(768));
        this.addIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                IndexModel indexModel = new IndexModel();
                indexModel.setIndexType(new IndexType("UNIQUE"));
                indexModel.setIndexName("IDX_" + TableEditDialog.this.txtTableName.getText() + "_" + (TableEditDialog.this.indexModels.size() + 1));
                TableEditDialog.this.indexModels.add(indexModel);
                TableEditDialog.this.indexList.add(indexModel.toString());
            }
        });
        this.delIndex = new Button(indexButtons, 8);
        this.delIndex.setText(DBPlugin.getResourceString("dialog.table.removeIndex"));
        this.delIndex.setLayoutData((Object)new GridData(768));
        this.delIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                int index = TableEditDialog.this.indexList.getSelectionIndex();
                TableEditDialog.this.indexList.remove(index);
                TableEditDialog.this.indexModels.remove(index);
                TableEditDialog.this.disableIndexForm();
            }
        });
        new Label(composite3, 0).setText(DBPlugin.getResourceString("dialog.table.editIndex.indexName"));
        this.indexName = new Text(composite3, 2048);
        this.indexName.setLayoutData((Object)new GridData(768));
        this.indexName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IndexModel model = (IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex);
                model.setIndexName(TableEditDialog.this.indexName.getText());
                TableEditDialog.this.indexList.setItem(TableEditDialog.this.editIndexIndex, model.toString());
            }
        });
        new Label(composite3, 0).setText(DBPlugin.getResourceString("dialog.table.editIndex.indexType"));
        this.indexType = new Combo(composite3, 8);
        int i3 = 0;
        while (i3 < this.dialect.getIndexTypes().length) {
            IIndexType type = this.dialect.getIndexTypes()[i3];
            this.indexType.add(type.getName());
            ++i3;
        }
        this.indexType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexModel model = (IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex);
                model.setIndexType(TableEditDialog.this.dialect.getIndexType(TableEditDialog.this.indexType.getText()));
                TableEditDialog.this.indexList.setItem(TableEditDialog.this.editIndexIndex, model.toString());
            }
        });
        Group indexColumn = new Group(composite3, 0);
        indexColumn.setText(DBPlugin.getResourceString("dialog.table.editIndex.indexColumns"));
        indexColumn.setLayout((Layout)new GridLayout(2, false));
        indexColumn.setLayoutData((Object)UIUtils.createGridData(3));
        this.selectedColumns = new org.eclipse.swt.widgets.List((Composite)indexColumn, 2816);
        this.selectedColumns.setLayoutData((Object)UIUtils.createGridDataWithColspan(1, 80));
        this.selectedColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditDialog.this.updateIndexColumnButtons();
            }
        });
        Composite indexColumnButtons = new Composite((Composite)indexColumn, 0);
        indexColumnButtons.setLayout((Layout)buttonsLayout);
        indexColumnButtons.setLayoutData((Object)new GridData(2));
        this.indexAddButton = new Button(indexColumnButtons, 8);
        this.indexAddButton.setLayoutData((Object)new GridData(768));
        this.indexAddButton.setText(DBPlugin.getResourceString("dialog.table.addColumn"));
        this.indexAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnSelectDialog dialog = new ColumnSelectDialog(TableEditDialog.this.getShell(), TableEditDialog.this.columnModels);
                if (dialog.open() == 0 && dialog.getSelectedColumn() != null) {
                    String columnName = dialog.getSelectedColumn().getColumnName();
                    IndexModel model = (IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex);
                    model.getColumns().add(columnName);
                    TableEditDialog.this.selectedColumns.add(columnName);
                    TableEditDialog.this.indexList.setItem(TableEditDialog.this.editIndexIndex, model.toString());
                    TableEditDialog.this.updateIndexColumnButtons();
                }
            }
        });
        this.indexRemoveButton = new Button(indexColumnButtons, 8);
        this.indexRemoveButton.setLayoutData((Object)new GridData(768));
        this.indexRemoveButton.setText(DBPlugin.getResourceString("dialog.table.removeColumn"));
        this.indexRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TableEditDialog.this.selectedColumns.getSelectionIndex();
                if (index >= 0) {
                    IndexModel model = (IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex);
                    model.getColumns().remove(index);
                    TableEditDialog.this.selectedColumns.remove(index);
                    TableEditDialog.this.updateIndexColumnButtons();
                }
            }
        });
        this.indexUpButton = new Button(indexColumnButtons, 8);
        this.indexUpButton.setText(DBPlugin.getResourceString("dialog.table.upColumn"));
        this.indexUpButton.setLayoutData((Object)new GridData(768));
        this.indexUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TableEditDialog.this.selectedColumns.getSelectionIndex();
                if (index > 0) {
                    IndexModel model = (IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex);
                    String columnName = model.getColumns().get(index);
                    model.getColumns().remove(index);
                    model.getColumns().add(index - 1, columnName);
                    TableEditDialog.this.selectedColumns.remove(index);
                    TableEditDialog.this.selectedColumns.add(columnName, index - 1);
                    TableEditDialog.this.selectedColumns.select(index - 1);
                    TableEditDialog.this.indexList.setItem(TableEditDialog.this.editIndexIndex, model.toString());
                    TableEditDialog.this.updateIndexColumnButtons();
                }
            }
        });
        this.indexDownButton = new Button(indexColumnButtons, 8);
        this.indexDownButton.setText(DBPlugin.getResourceString("dialog.table.downColumn"));
        this.indexDownButton.setLayoutData((Object)new GridData(768));
        this.indexDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TableEditDialog.this.selectedColumns.getSelectionIndex();
                if (index < ((IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex)).getColumns().size() - 1) {
                    IndexModel model = (IndexModel)TableEditDialog.this.indexModels.get(TableEditDialog.this.editIndexIndex);
                    String columnName = model.getColumns().get(index);
                    model.getColumns().remove(index);
                    model.getColumns().add(index + 1, columnName);
                    TableEditDialog.this.selectedColumns.remove(index);
                    TableEditDialog.this.selectedColumns.add(columnName, index + 1);
                    TableEditDialog.this.selectedColumns.select(index + 1);
                    TableEditDialog.this.indexList.setItem(TableEditDialog.this.editIndexIndex, model.toString());
                    TableEditDialog.this.updateIndexColumnButtons();
                }
            }
        });
        if (this.indexEditing) {
            tabFolder.setSelection(tab3);
            if (this.editIndexIndex >= 0) {
                this.indexList.select(this.editIndexIndex);
                this.indexSelectionChanged();
            } else {
                this.disableIndexForm();
            }
        } else {
            this.disableIndexForm();
        }
        TabItem tab4 = new TabItem(tabFolder, 0);
        tab4.setText(DBPlugin.getResourceString("label.sql"));
        Composite sqlComposite = new Composite((Composite)tabFolder, 0);
        sqlComposite.setLayout((Layout)new GridLayout(2, false));
        Composite editorArea = new Composite(sqlComposite, 2048);
        editorArea.setLayout((Layout)new FillLayout());
        editorArea.setLayoutData((Object)UIUtils.createGridData(2, 1808));
        SourceViewer sqlEditor = new SourceViewer(editorArea, (IVerticalRuler)new VerticalRuler(0), 768);
        sqlEditor.configure((SourceViewerConfiguration)new SQLConfiguration());
        sqlEditor.getTextWidget().setFont(JFaceResources.getTextFont());
        Document document = new Document();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(), new String[]{"__sql_comment", "__sql_string"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        sqlEditor.setDocument((IDocument)document);
        this.txtSql = sqlEditor.getTextWidget();
        this.txtSql.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableEditDialog.this.sql = TableEditDialog.this.txtSql.getText();
            }
        });
        Button insertButton = new Button(sqlComposite, 8);
        insertButton.setText(DBPlugin.getResourceString("dialog.table.insertSql"));
        insertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder columns = new StringBuilder();
                int i = 0;
                while (i < TableEditDialog.this.columnModels.size()) {
                    if (columns.length() != 0) {
                        columns.append(", ");
                    }
                    columns.append(((ColumnModel)TableEditDialog.this.columnModels.get(i)).getColumnName());
                    ++i;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO ");
                sb.append(TableEditDialog.this.txtTableName.getText());
                sb.append(" (");
                sb.append(columns.toString());
                sb.append(") VALUES (");
                sb.append(columns.toString());
                sb.append(");");
                TableEditDialog.this.txtSql.insert(sb.toString());
                TableEditDialog.this.txtSql.setFocus();
            }
        });
        Button insertNotNullButton = new Button(sqlComposite, 8);
        insertNotNullButton.setText(DBPlugin.getResourceString("dialog.table.insertNotNullSql"));
        insertNotNullButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder columns = new StringBuilder();
                int i = 0;
                while (i < TableEditDialog.this.columnModels.size()) {
                    if (((ColumnModel)TableEditDialog.this.columnModels.get(i)).isNotNull()) {
                        if (columns.length() != 0) {
                            columns.append(", ");
                        }
                        columns.append(((ColumnModel)TableEditDialog.this.columnModels.get(i)).getColumnName());
                    }
                    ++i;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO ");
                sb.append(TableEditDialog.this.txtTableName.getText());
                sb.append(" (");
                sb.append(columns.toString());
                sb.append(") VALUES (");
                sb.append(columns.toString());
                sb.append(");");
                TableEditDialog.this.txtSql.insert(sb.toString());
                TableEditDialog.this.txtSql.setFocus();
            }
        });
        tab4.setControl((Control)sqlComposite);
        this.txtSql.setText(this.sql);
        return tabFolder;
    }

    private void indexSelectionChanged() {
        this.editIndexIndex = this.indexList.getSelectionIndex();
        if (this.editIndexIndex >= 0) {
            IndexModel model = this.indexModels.get(this.editIndexIndex);
            this.indexName.setEnabled(true);
            this.indexType.setEnabled(true);
            this.selectedColumns.setEnabled(true);
            this.selectedColumns.removeAll();
            this.indexName.setText(model.getIndexName());
            this.indexType.setText(model.getIndexType().getName());
            this.indexAddButton.setEnabled(true);
            this.delIndex.setEnabled(true);
            for (String columnName : model.getColumns()) {
                this.selectedColumns.add(columnName);
            }
        } else {
            this.disableIndexForm();
        }
    }

    private void updateIndexColumnButtons() {
        this.indexRemoveButton.setEnabled(false);
        this.indexUpButton.setEnabled(false);
        this.indexDownButton.setEnabled(false);
        int index = this.selectedColumns.getSelectionIndex();
        if (index >= 0) {
            this.indexRemoveButton.setEnabled(true);
            if (index > 0) {
                this.indexUpButton.setEnabled(true);
            } else if (index < this.selectedColumns.getItemCount() - 1) {
                this.indexDownButton.setEnabled(true);
            }
        }
    }

    private void updateButtons() {
        this.btnDelColumn.setEnabled(false);
        this.btnUpColumn.setEnabled(false);
        this.btnDownColumn.setEnabled(false);
        int index = this.tblColumns.getSelectionIndex();
        if (index >= 0) {
            this.btnDelColumn.setEnabled(true);
            if (index > 0) {
                this.btnUpColumn.setEnabled(true);
            }
            if (index < this.columnModels.size() - 1) {
                this.btnDownColumn.setEnabled(true);
            }
        }
    }

    private void disableColumnForm() {
        this.editColumnIndex = -1;
        this.txtColumnName.setText("");
        this.txtColumnLogicalName.setText("");
        this.cmbColumnType.setText("");
        this.txtColumnSize.setText("");
        this.chkIsPK.setSelection(false);
        this.chkNotNull.setSelection(false);
        this.autoIncrement.setSelection(false);
        this.defaultValue.setText("");
        this.txtColumnName.setEnabled(false);
        this.txtColumnLogicalName.setEnabled(false);
        this.cmbColumnType.setEnabled(false);
        this.txtColumnSize.setEnabled(false);
        this.txtColumnDescription.setEnabled(false);
        this.chkIsPK.setEnabled(false);
        this.chkNotNull.setEnabled(false);
        this.autoIncrement.setEnabled(false);
        this.defaultValue.setEnabled(false);
    }

    private void disableIndexForm() {
        this.editIndexIndex = -1;
        this.indexName.setText("");
        this.indexType.setText("");
        this.selectedColumns.removeAll();
        this.indexName.setEnabled(false);
        this.indexType.setEnabled(false);
        this.selectedColumns.setEnabled(false);
        this.delIndex.setEnabled(false);
        this.indexAddButton.setEnabled(false);
        this.indexRemoveButton.setEnabled(false);
        this.indexUpButton.setEnabled(false);
        this.indexDownButton.setEnabled(false);
    }

    private void updateColumn() {
        if (this.editColumnIndex != -1 && this.cmbColumnType.getSelectionIndex() != -1) {
            ColumnModel model = this.columnModels.get(this.editColumnIndex);
            model.setColumnName(this.txtColumnName.getText());
            model.setLogicalName(this.txtColumnLogicalName.getText());
            int columnIndex = this.cmbColumnType.getSelectionIndex();
            if (columnIndex < this.rootModel.getDommains().size()) {
                model.setDommain(this.rootModel.getDommains().get(columnIndex));
            } else {
                model.setDommain(null);
                model.setColumnType(this.dialect.getColumnTypes()[this.cmbColumnType.getSelectionIndex() - this.rootModel.getDommains().size()]);
            }
            model.setSize(this.txtColumnSize.getText());
            model.setPrimaryKey(this.chkIsPK.getSelection());
            model.setNotNull(this.chkNotNull.getSelection());
            model.setDescription(this.txtColumnDescription.getText());
            model.setAutoIncrement(this.autoIncrement.getSelection());
            model.setDefaultValue(this.defaultValue.getText());
            TableItem item = this.tblColumns.getItem(this.editColumnIndex);
            this.updateTableItem(item, model);
            if (model.getDommain() == null) {
                this.txtColumnSize.setEnabled(model.getColumnType().supportSize());
            } else {
                this.txtColumnSize.setEnabled(false);
            }
        }
    }

    private void tableSelectionChanged() {
        int index = this.tblColumns.getSelectionIndex();
        if (index >= 0) {
            ColumnModel model = this.columnModels.get(index);
            this.txtColumnName.setText(model.getColumnName());
            this.txtColumnLogicalName.setText(model.getLogicalName());
            if (model.getDommain() == null) {
                this.cmbColumnType.setText(model.getColumnType().toString());
            } else {
                this.cmbColumnType.setText(model.getDommain().toString());
            }
            this.txtColumnSize.setText(String.valueOf(model.getSize()));
            this.txtColumnDescription.setText(model.getDescription());
            this.chkIsPK.setSelection(model.isPrimaryKey());
            this.chkNotNull.setSelection(model.isNotNull());
            this.autoIncrement.setSelection(model.isAutoIncrement());
            this.defaultValue.setText(model.getDefaultValue());
            this.editColumnIndex = index;
            this.txtColumnName.setEnabled(true);
            this.txtColumnLogicalName.setEnabled(true);
            this.cmbColumnType.setEnabled(true);
            if (model.getDommain() == null) {
                this.txtColumnSize.setEnabled(model.getColumnType().supportSize());
            } else {
                this.txtColumnSize.setEnabled(false);
            }
            this.txtColumnDescription.setEnabled(true);
            this.chkIsPK.setEnabled(true);
            this.chkNotNull.setEnabled(true);
            this.autoIncrement.setEnabled(true);
            this.defaultValue.setEnabled(true);
        } else {
            this.disableColumnForm();
        }
        this.updateButtons();
    }

    protected void okPressed() {
        this.tableName = this.txtTableName.getText();
        this.tableLogicalName = this.txtTableLogicalName.getText();
        this.tableDescription = this.txtTableDescription.getText();
        super.okPressed();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableLogicalName() {
        return this.tableLogicalName;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public List<ColumnModel> getResultColumns() {
        return this.columnModels;
    }

    public List<IndexModel> getResultIncices() {
        return this.indexModels;
    }

    public String getSql() {
        return this.sql;
    }

    private void updateTableItem(TableItem item, ColumnModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append(model.getColumnType().getName());
        if (model.getColumnType().supportSize() && model.getSize().length() > 0) {
            sb.append("(").append(model.getSize()).append(")");
        }
        item.setText(0, model.getLogicalName());
        item.setText(1, model.getColumnName());
        item.setText(2, sb.toString());
        item.setText(3, String.valueOf(model.isPrimaryKey()));
        item.setText(4, String.valueOf(model.isNotNull()));
    }
}

