/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.editpart.ColumnFigure;
import net.java.amateras.db.visual.editpart.CompartmentFigure;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.widgets.Display;

public class TableFigure
extends Figure {
    private Label name = new Label();
    private ColumnLayoutFigure columnFigure;
    private CompartmentFigure columnNameFigure;
    private CompartmentFigure columnTypeFigure;
    private CompartmentFigure notNullFigure;
    private int flag = 0;

    public TableFigure() {
        this.name.setBorder((Border)new MarginBorder(2, 2, 0, 2));
        this.columnNameFigure = new CompartmentFigure();
        this.columnTypeFigure = new CompartmentFigure();
        this.notNullFigure = new CompartmentFigure();
        this.columnFigure = new ColumnLayoutFigure();
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.setOpaque(true);
        this.add((IFigure)this.name);
        this.add((IFigure)this.columnFigure);
        this.columnFigure.add((IFigure)this.columnNameFigure);
        this.columnFigure.add((IFigure)this.columnTypeFigure);
        this.columnFigure.add((IFigure)this.notNullFigure);
    }

    public void setTableName(String tableName) {
        this.name.setText(tableName);
    }

    public void setErrorMessage(String message) {
        if (message == null || message.length() == 0) {
            this.name.setIcon(null);
            this.name.setToolTip(null);
        } else {
            if (message.indexOf("[ERROR]") >= 0) {
                this.name.setIcon(DBPlugin.getImage("icons/error.gif"));
            } else {
                this.name.setIcon(DBPlugin.getImage("icons/warning.gif"));
            }
            this.name.setToolTip((IFigure)new Label(message));
        }
    }

    public void setLinkedTable(boolean linked) {
        if (linked) {
            this.setForegroundColor(Display.getDefault().getSystemColor(15));
            ((LineBorder)this.getBorder()).setColor(Display.getDefault().getSystemColor(15));
        } else {
            this.setForegroundColor(Display.getDefault().getSystemColor(2));
            ((LineBorder)this.getBorder()).setColor(Display.getDefault().getSystemColor(2));
        }
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof ColumnFigure) {
            if (this.flag == 0) {
                this.columnNameFigure.add(figure);
                this.flag = 1;
            } else if (this.flag == 1) {
                this.columnTypeFigure.add(figure);
                this.flag = 2;
            } else {
                this.notNullFigure.add(figure);
                this.flag = 0;
            }
        } else {
            super.add(figure, constraint, index);
        }
    }

    public void remove(IFigure figure) {
        if (figure instanceof ColumnFigure) {
            this.columnNameFigure.remove(figure);
            this.columnTypeFigure.remove(figure);
            this.notNullFigure.remove(figure);
        } else {
            super.remove(figure);
        }
    }

    public void removeAllColumns() {
        this.columnNameFigure.removeAll();
        this.columnTypeFigure.removeAll();
        this.notNullFigure.removeAll();
    }

    public Label getLabel() {
        return this.name;
    }

    private class ColumnLayoutFigure
    extends Figure {
        public ColumnLayoutFigure() {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(2);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new CompartmentFigureBorder());
        }
    }

    public class CompartmentFigureBorder
    extends AbstractBorder {
        public Insets getInsets(IFigure figure) {
            return new Insets(1, 0, 2, 0);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.drawLine(CompartmentFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getTopRight());
        }
    }
}

