/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.editpart.tree;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.editpart.TableEditPart;
import net.java.amateras.db.visual.editpart.tree.AbstractDBTreeEditPart;
import net.java.amateras.db.visual.editpart.tree.FolderTreeEditPart;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TableTreeEditPart
extends AbstractDBTreeEditPart {
    private static final String IMAGE_TABLE_ERROR = "image_table_error";
    private static final String IMAGE_TABLE_WARNING = "image_table_warning";

    static {
        DBPlugin.getDefault().getImageRegistry().put(IMAGE_TABLE_ERROR, (ImageDescriptor)new OverlayImageDescriptor("icons/table.gif", "icons/ovr_error.gif"));
        DBPlugin.getDefault().getImageRegistry().put(IMAGE_TABLE_WARNING, (ImageDescriptor)new OverlayImageDescriptor("icons/table.gif", "icons/ovr_warning.gif"));
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        ColumnModel[] columns = ((TableModel)this.getModel()).getColumns();
        int i = 0;
        while (i < columns.length) {
            list.add(columns[i]);
            ++i;
        }
        list.add(new FolderTreeEditPart.FolderModel(DBPlugin.getResourceString("label.index"), null){

            @Override
            public void doEdit() {
                TableModel table = (TableModel)TableTreeEditPart.this.getModel();
                if (table.isLinkedTable()) {
                    UIUtils.openAlertDialog(DBPlugin.getResourceString("error.edit.linkedTable"));
                    return;
                }
                TableEditPart.openTableEditDialog(TableTreeEditPart.this.getViewer(), table, (RootModel)TableTreeEditPart.this.getRoot().getContents().getModel(), null);
            }

            @Override
            public List<?> getChildren() {
                IndexModel[] indices = ((TableModel)TableTreeEditPart.this.getModel()).getIndices();
                ArrayList<IndexModel> list = new ArrayList<IndexModel>();
                IndexModel[] indexModelArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    IndexModel indexModel = indexModelArray[n2];
                    list.add(indexModel);
                    ++n2;
                }
                return list;
            }
        });
        return list;
    }

    protected void refreshVisuals() {
        TableModel model = (TableModel)this.getModel();
        this.setWidgetText(String.valueOf(model.getTableName()) + "(" + model.getLogicalName() + ")");
        if (model.getError().length() == 0) {
            this.setWidgetImage(DBPlugin.getImage("icons/table.gif"));
        } else if (model.getError().indexOf("[ERROR]") >= 0) {
            this.setWidgetImage(DBPlugin.getImage(IMAGE_TABLE_ERROR));
        } else {
            this.setWidgetImage(DBPlugin.getImage(IMAGE_TABLE_WARNING));
        }
        List children = this.getChildren();
        for (AbstractEditPart child : children) {
            child.refresh();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        TableModel model = (TableModel)this.getModel();
        if ("p_logical_name".equals(propName) || "p_table_name".equals(propName)) {
            this.setWidgetText(String.valueOf(model.getTableName()) + "(" + model.getLogicalName() + ")");
        } else if ("p_error".equals(propName)) {
            this.refreshVisuals();
        }
        if ("p_columns".equals(propName) || "p_indices".equals(propName)) {
            this.refreshChildren();
            List children = this.getChildren();
            for (AbstractEditPart child : children) {
                child.refresh();
            }
        }
    }

    private static class OverlayImageDescriptor
    extends CompositeImageDescriptor {
        private String baseImageKey;
        private String overlayImageKey;

        public OverlayImageDescriptor(String baseImageKey, String overlayImageKey) {
            this.baseImageKey = baseImageKey;
            this.overlayImageKey = overlayImageKey;
        }

        protected void drawCompositeImage(int arg0, int arg1) {
            Image baseImage = DBPlugin.getImage(this.baseImageKey);
            this.drawImage(baseImage.getImageData(), 0, 0);
            Image overlayImage = DBPlugin.getImage(this.overlayImageKey);
            this.drawImage(overlayImage.getImageData(), 0, 8);
        }

        protected Point getSize() {
            return new Point(16, 16);
        }
    }
}

