/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.generate;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.generate.IGenerator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class GeneratorProvider {
    private static List<IGenerator> contributedGenerators = null;

    public static IGenerator[] getGeneraters() {
        if (contributedGenerators == null) {
            contributedGenerators = new ArrayList<IGenerator>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("net.java.amateras.db.generators");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        if ("generator".equals(elements[j].getName())) {
                            IGenerator generator = (IGenerator)elements[j].createExecutableExtension("class");
                            contributedGenerators.add(generator);
                        }
                    }
                    catch (Exception ex) {
                        DBPlugin.logException(ex);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return contributedGenerators.toArray(new IGenerator[contributedGenerators.size()]);
    }
}

