/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ForeignKeyModel
extends AbstractDBConnectionModel {
    private static final long serialVersionUID = -3257258783438506904L;
    private String foreignKeyName = "";
    private Map<ColumnModel, ColumnModel> references = new HashMap<ColumnModel, ColumnModel>();
    public static final String P_FOREIGN_KEY_NAME = "p_foreign_key_name";
    public static final String P_FOREIGN_KEY_MAPPING = "p_foreign_key_mapping";

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
        this.firePropertyChange(P_FOREIGN_KEY_NAME, null, foreignKeyName);
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setMapping(ForeignKeyMapping[] mapping) {
        this.references.clear();
        int i = 0;
        while (i < mapping.length) {
            this.references.put(mapping[i].getTarget(), mapping[i].getRefer());
            ++i;
        }
        this.firePropertyChange(P_FOREIGN_KEY_MAPPING, null, mapping);
    }

    public ForeignKeyMapping[] getMapping() {
        ArrayList<ForeignKeyMapping> list = new ArrayList<ForeignKeyMapping>();
        TableModel target = (TableModel)this.getTarget();
        ColumnModel[] targetColumns = target.getColumns();
        int i = 0;
        while (i < targetColumns.length) {
            if (targetColumns[i].isPrimaryKey()) {
                int j;
                ForeignKeyMapping mapping = new ForeignKeyMapping();
                mapping.setTarget(targetColumns[i]);
                ColumnModel referColumn = this.references.get(targetColumns[i]);
                TableModel source = (TableModel)this.getSource();
                ColumnModel[] sourceColumns = source.getColumns();
                if (referColumn != null) {
                    j = 0;
                    while (j < sourceColumns.length) {
                        if (sourceColumns[j] == referColumn) {
                            mapping.setRefer(referColumn);
                            break;
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < sourceColumns.length) {
                        if (sourceColumns[j].getColumnName().equals(targetColumns[i].getColumnName())) {
                            referColumn = sourceColumns[j];
                            break;
                        }
                        ++j;
                    }
                    if (referColumn != null) {
                        mapping.setRefer(referColumn);
                    }
                }
                list.add(mapping);
            }
            ++i;
        }
        return list.toArray(new ForeignKeyMapping[list.size()]);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> descriptoes = new ArrayList<TextPropertyDescriptor>();
        descriptoes.add(new TextPropertyDescriptor((Object)P_FOREIGN_KEY_NAME, DBPlugin.getResourceString("property.foreignKeyName")));
        return descriptoes.toArray(new IPropertyDescriptor[descriptoes.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id == P_FOREIGN_KEY_NAME) {
            return this.getForeignKeyName();
        }
        return null;
    }

    @Override
    public boolean isPropertySet(Object id) {
        return id == P_FOREIGN_KEY_NAME;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id == P_FOREIGN_KEY_NAME) {
            this.setForeignKeyName((String)value);
        }
    }
}

