/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.visual.model;

import java.util.ArrayList;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.AnchorModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ICloneableModel;
import net.java.amateras.db.visual.model.IndexModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TableModel
extends AbstractDBEntityModel
implements ICloneableModel {
    private static final long serialVersionUID = 5840664750723834315L;
    private String error = "";
    private String linkedPath = "";
    private String tableName = "";
    private String logicalName = "";
    private String description = "";
    private ColumnModel[] columns = new ColumnModel[0];
    private IndexModel[] indices = new IndexModel[0];
    private RGB backgroundColor;
    private String sql = "";
    private String schema;
    public static final String P_ERROR = "p_error";
    public static final String P_TABLE_NAME = "p_table_name";
    public static final String P_LOGICAL_NAME = "p_logical_name";
    public static final String P_COLUMNS = "p_columns";
    public static final String P_INDICES = "p_indices";
    public static final String P_CONSTRAINT = "p_constraint";
    public static final String P_LINKED_PATH = "p_linked_path";
    public static final String P_BACKGROUND_COLOR = "p_background_color";
    public static final String P_SCHEMA = "p_schema";

    @Override
    public boolean canSource(AbstractDBConnectionModel conn) {
        return !(conn instanceof AnchorModel) || conn.getTarget() == null || !(conn.getTarget() instanceof TableModel);
    }

    @Override
    public boolean canTarget(AbstractDBConnectionModel conn) {
        return !(conn instanceof AnchorModel) || !(conn.getSource() instanceof TableModel);
    }

    public ColumnModel[] getPrimaryKeyColumns() {
        ArrayList<ColumnModel> primaryKeyColumns = new ArrayList<ColumnModel>();
        ColumnModel[] columnModelArray = this.getColumns();
        int n = columnModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnModel columnModel = columnModelArray[n2];
            if (columnModel.isPrimaryKey()) {
                primaryKeyColumns.add(columnModel);
            }
            ++n2;
        }
        return primaryKeyColumns.toArray(new ColumnModel[primaryKeyColumns.size()]);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        if (this.sql == null) {
            this.sql = "";
        }
        return this.sql;
    }

    public boolean isLinkedTable() {
        return this.getLinkedPath().length() != 0;
    }

    public String getLinkedPath() {
        if (this.linkedPath == null) {
            this.linkedPath = "";
        }
        return this.linkedPath;
    }

    public void setLinkedPath(String linkedPath) {
        this.linkedPath = linkedPath;
        this.firePropertyChange(P_LINKED_PATH, null, linkedPath);
    }

    public String getError() {
        if (this.error == null) {
            this.error = "";
        }
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
        this.firePropertyChange(P_ERROR, null, error);
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
        this.firePropertyChange(P_LOGICAL_NAME, null, logicalName);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.firePropertyChange(P_TABLE_NAME, null, tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setColumns(ColumnModel[] columns) {
        this.columns = columns;
        this.firePropertyChange(P_COLUMNS, null, columns);
    }

    public ColumnModel[] getColumns() {
        return this.columns;
    }

    public ColumnModel getColumn(String columnName) {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].getColumnName().equals(columnName)) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    public IndexModel[] getIndices() {
        if (this.indices == null) {
            this.indices = new IndexModel[0];
        }
        return this.indices;
    }

    public void setIndices(IndexModel[] indices) {
        this.indices = indices;
        this.firePropertyChange(P_INDICES, null, indices);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        this.firePropertyChange(P_SCHEMA, null, schema);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.isLinkedTable()) {
            return new IPropertyDescriptor[]{new PropertyDescriptor((Object)P_TABLE_NAME, DBPlugin.getResourceString("property.physicalTableName")), new PropertyDescriptor((Object)P_LOGICAL_NAME, DBPlugin.getResourceString("property.logicalTableName")), new PropertyDescriptor((Object)P_LINKED_PATH, DBPlugin.getResourceString("property.linkedPath")), new PropertyDescriptor((Object)P_SCHEMA, DBPlugin.getResourceString("property.schema"))};
        }
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_TABLE_NAME, DBPlugin.getResourceString("property.physicalTableName")), new TextPropertyDescriptor((Object)P_LOGICAL_NAME, DBPlugin.getResourceString("property.logicalTableName")), new ColorPropertyDescriptor((Object)P_BACKGROUND_COLOR, DBPlugin.getResourceString("property.backgroundColor"))};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id == P_TABLE_NAME) {
            return this.getTableName();
        }
        if (id == P_LOGICAL_NAME) {
            return this.getLogicalName();
        }
        if (id == P_LINKED_PATH) {
            return this.getLinkedPath();
        }
        if (id == P_BACKGROUND_COLOR) {
            return this.getBackgroundColor();
        }
        if (id == P_SCHEMA) {
            return this.getSchema();
        }
        return null;
    }

    @Override
    public boolean isPropertySet(Object id) {
        return id == P_TABLE_NAME || id == P_LOGICAL_NAME || id == P_BACKGROUND_COLOR || id == P_SCHEMA;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id == P_TABLE_NAME) {
            this.setTableName((String)value);
        } else if (id == P_LOGICAL_NAME) {
            this.setLogicalName((String)value);
        } else if (id == P_BACKGROUND_COLOR) {
            this.setBackgroundColor((RGB)value);
        } else if (id == P_SCHEMA) {
            this.setSchema((String)value);
        }
    }

    public RGB getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = new RGB(255, 255, 206);
        }
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGB backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.firePropertyChange(P_BACKGROUND_COLOR, null, backgroundColor);
    }

    @Override
    public ICloneableModel clone() {
        TableModel table = new TableModel();
        table.setTableName(this.getTableName());
        table.setLogicalName(this.getLogicalName());
        table.setDescription(this.getDescription());
        table.setLinkedPath(this.getLinkedPath());
        table.setConstraint(new Rectangle(this.getConstraint()));
        table.setBackgroundColor(this.getBackgroundColor());
        table.setSchema(this.getSchema());
        ColumnModel[] oldColumns = this.getColumns();
        ColumnModel[] newColumns = new ColumnModel[oldColumns.length];
        int i = 0;
        while (i < oldColumns.length) {
            newColumns[i] = new ColumnModel();
            newColumns[i].setColumnName(oldColumns[i].getColumnName());
            newColumns[i].setLogicalName(oldColumns[i].getLogicalName());
            newColumns[i].setDescription(oldColumns[i].getDescription());
            newColumns[i].setDefaultValue(oldColumns[i].getDefaultValue());
            newColumns[i].setColumnType(oldColumns[i].getColumnType());
            newColumns[i].setNotNull(oldColumns[i].isNotNull());
            newColumns[i].setPrimaryKey(oldColumns[i].isPrimaryKey());
            newColumns[i].setDommain(oldColumns[i].getDommain());
            newColumns[i].setSize(oldColumns[i].getSize());
            ++i;
        }
        table.setColumns(newColumns);
        return table;
    }
}

