/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.wizard;

import java.io.InputStream;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.visual.editor.VisualDBSerializer;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.wizard.NewDiagramWizardPage2;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewDiagramWizardPage1
extends WizardNewFileCreationPage {
    private Combo combo;
    private NewDiagramWizardPage2 page2;

    public NewDiagramWizardPage1(IStructuredSelection selection, NewDiagramWizardPage2 page2) {
        super(DBPlugin.getResourceString("wizard.new.erd.title"), selection);
        this.setTitle(DBPlugin.getResourceString("wizard.new.erd.title"));
        this.setFileName("newfile.erd");
        this.page2 = page2;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = new Composite((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(DBPlugin.getResourceString("wizard.new.erd.dialect"));
        this.combo = new Combo(composite, 8);
        String[] dialectNames = DialectProvider.getDialectNames();
        int i = 0;
        while (i < dialectNames.length) {
            this.combo.add(dialectNames[i]);
            ++i;
        }
        this.combo.setText(dialectNames[0]);
        this.validatePage();
    }

    protected void createLinkTarget() {
    }

    protected boolean validatePage() {
        String fileName;
        boolean valid = super.validatePage();
        if (valid && !(fileName = this.getFileName()).endsWith(".erd")) {
            this.setErrorMessage(DBPlugin.getResourceString("error.erd.extension"));
            valid = false;
        }
        if (valid) {
            this.setMessage(DBPlugin.getResourceString("wizard.new.erd.message"));
        }
        return valid;
    }

    protected InputStream getInitialContents() {
        RootModel root = new RootModel();
        root.setDialectName(this.combo.getText());
        try {
            this.page2.importTables(root);
            return VisualDBSerializer.serialize(root);
        }
        catch (Exception ex) {
            DBPlugin.logException(ex);
            return null;
        }
    }
}

